<?php
// Habilitar errores para depuración
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Cargar correctamente autoload.php
require __DIR__ . '/../../vendor/autoload.php';
//require __DIR__ . '/../../../vendor/autoload.php';


use Pusher\Pusher;

class Notificacion {

    private $pusher;

    public function __construct() {
        // Configuración de Pusher
        $options = [
            'cluster' => 'us2', 
            'useTLS'  => true
        ];

        try {
            $this->pusher = new Pusher(
                '01c14cdca26db19318e0',   // API Key
                '72ae4a02574062586697',   // Secret Key
                '1768686',                // App ID
                $options
            );
        } catch (Exception $e) {
            die(json_encode(['success' => false, 'message' => 'Error al conectar con Pusher: ' . $e->getMessage()]));
        }
    }

    /**
     * Envía una notificación simple.
     */
    public function enviarNotificacion() {
        // Datos mínimos para la notificación
        $data = [
            'message' => '🔔 Nueva notificación desde el controlador'
        ];

        // Envía el evento al canal "notifications-channel"
        try {
            $result = $this->pusher->trigger('pale-channel', 'new-notification', $data);
            if(!$result){
                echo json_encode([
                'success' => true,
                'message' => '❌ Error al enviar la notificación:',
                'result' => $result
                ]);
            }
            
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => '❌ Error al enviar la notificación: ' . $e->getMessage()
            ]);
        }
    }

    public function enviarNotificacionMostrador() {
        // Datos mínimos para la notificación
        $data = [
            'message' => '🔔 Nueva notificación desde el controlador'
        ];

        // Envía el evento al canal "notifications-channel"
        try {
            $result = $this->pusher->trigger('pale-channel', 'notification-mostrador', $data);
            if(!$result){
                echo json_encode([
                'success' => true,
                'message' => '❌ Error al enviar la notificación:',
                'result' => $result
                ]);
            }
            
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => '❌ Error al enviar la notificación: ' . $e->getMessage()
            ]);
        }
    }

    public function enviarNotificacionDelivery() {
        // Datos mínimos para la notificación
        $data = [
            'message' => '🔔 Nueva notificación desde el controlador'
        ];

        // Envía el evento al canal "notifications-channel"
        try {
            $result = $this->pusher->trigger('pale-channel', 'notification-delivery', $data);
            if(!$result){
                echo json_encode([
                'success' => true,
                'message' => '❌ Error al enviar la notificación:',
                'result' => $result
                ]);
            }
            
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => '❌ Error al enviar la notificación: ' . $e->getMessage()
            ]);
        }
    }

    public function enviarNotificacionVentaRapida() {
        // Datos mínimos para la notificación
        $data = [
            'message' => '🔔 Nueva notificación desde el controlador'
        ];

        // Envía el evento al canal "notifications-channel"
        try {
            $result = $this->pusher->trigger('pale-channel', 'notification-ventaRapida', $data);
            if(!$result){
                echo json_encode([
                'success' => true,
                'message' => '❌ Error al enviar la notificación:',
                'result' => $result
                ]);
            }
            
            
        } catch (Exception $e) {
            echo json_encode([
                'success' => false,
                'message' => '❌ Error al enviar la notificación: ' . $e->getMessage()
            ]);
        }
    }
}
