<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === TABS MODERNOS === */
.nav-tabs-modern {
    border-bottom: 2px solid #e9ecef;
    margin-bottom: 0;
}

.nav-tabs-modern .nav-link {
    border: none;
    color: #6c757d;
    font-weight: 500;
    padding: 1rem 1.5rem;
    position: relative;
    transition: var(--transition);
}

.nav-tabs-modern .nav-link:hover {
    color: var(--primary-color);
    background: transparent;
}

.nav-tabs-modern .nav-link.active {
    color: var(--primary-color);
    background: transparent;
    border-bottom: 3px solid var(--primary-color);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === TABLA MODERN === */
.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.005);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}
/* === RESPONSIVE UTILS === */
@media (max-width: 768px) {
    .nav-tabs-modern {
        flex-wrap: nowrap !important;
        overflow-x: auto;
        overflow-y: hidden;
        -webkit-overflow-scrolling: touch;
        justify-content: flex-start !important;
        padding-bottom: 5px;
    }
    
    .nav-tabs-modern .nav-item {
        white-space: nowrap;
    }

    .nav-tabs-modern .nav-link {
        padding: 0.8rem    #ul-cat {
        max-height: 250px !important;
    }
}

/* === INTERNAL FORM DEEP MODERNIZATION === */
/* File Upload / Wizard Modernization */
.picture-container-modern {
    position: relative;
    cursor: pointer;
    text-align: center;
    transition: all 0.3s ease;
}
.picture-container-modern .picture {
    width: 140px;
    height: 140px;
    background-color: #f8f9fa;
    border: 2px dashed #dce2e6; /* Dashed border for "dropzone" feel */
    color: #adb5bd;
    border-radius: 50%;
    margin: 0px auto;
    overflow: hidden;
    transition: all 0.3s;
    position: relative;
    display: flex;
    justify-content: center;
    align-items: center;
}
.picture-container-modern:hover .picture {
    border-color: var(--primary-color);
    box-shadow: 0 5px 15px rgba(86, 100, 210, 0.2);
    transform: scale(1.02);
}
.picture-container-modern input[type="file"] {
    cursor: pointer;
    display: block;
    height: 100%;
    left: 0;
    opacity: 0 !important;
    position: absolute;
    top: 0;
    width: 100%;
    z-index: 100;
}
.picture-src {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
</style>

<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Restaurante</a></span>
            <span class="breadcrumb-item active">Combos</span>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-3">
        <div class="card card-modern h-100">         
            <div class="card-body">
                <h4 class="card-title text-primary mb-3 font-weight-bold"><i class="ti-layout-grid2 font-18 mr-2"></i> Combos</h4>                    
                <ul class="list-style-none">
                    <li class="font-14 mb-3 text-muted">Permite crear productos que a su vez están compuestos por otros productos.</li>
                    <li class="font-14 text-muted">Un combo puede contener varios productos, como por ejemplo:</li>
                </ul>
                <div class="p-3 bg-light mt-4 rounded shadow-sm">
                    <h6 class="card-title text-warning mb-2 font-weight-bold"><i class="mdi mdi-food display-6 mr-1"></i> Combo 01</h6> 
                    <ul class="pl-3 mb-0 text-muted">
                        <li class="font-14">Hamburguesa</li>
                        <li class="font-14">Inka Cola 500 ml</li>                        
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-9">
        <div class="card card-modern h-100">
            <div class="card-body p-0">
                <div class="p-4 border-bottom">
                     <ul class="nav nav-tabs nav-tabs-modern justify-content-center" role="tablist">
                         <li class="nav-item">
                            <a href="producto" class="nav-link">
                                <i class="mdi mdi-food-fork-drink font-18 mr-2"></i> Platos y bebidas
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="combo" class="nav-link active">
                                <i class="mdi mdi-food font-18 mr-2"></i> Combos
                            </a>                        
                        </li>
                        <li class="nav-item">
                            <a href="insumo" class="nav-link">
                                <i class="mdi mdi-food-variant font-18 mr-2"></i> Insumos
                            </a>
                        </li>
                    </ul>
                </div>
                
                <div class="row px-4 floating-labels pt-4">
                    <div class="col-lg-7 p-0">
                        <div class="row">
                            <div class="col-lg-5 mb-3">
                                <button class="btn btn-success btn-block btn-nuevo-combo btn-modern btn-modern-success" id="step1"><i class="fa fa-plus-circle mr-1"></i> Nuevo combo</button>
                            </div>
                            <div class="col-lg-7 mb-3" id="filter_global">
                                <div class="form-group m-b-0 form-group-modern">
                                    <input class="form-control global_filter" id="global_filter" type="text" placeholder="Buscar combo...">
                                    <span class="bar"></span>
                                    <label for="global_filter"><i class="fa fa-search mr-1"></i> Buscar combo</label>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive b-t m-b-10 table-responsive-modern">
                            <table class="table table-hover table-modern" width="100%" id="table-productos">
                                <thead>
                                    <th>Combo</th>
                                    <th style="text-align: right">Activo</th>
                                    <th></th>
                                </thead>
                                <tbody class="tb-st"></tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Column -->
                    <div class="col-lg-5 p-t-20 p-b-20 b-l" style="background: #ffffff;" id="step2">
                        <div id="head-p"></div>
                        <div id="body-c"></div>
                        <div id="body-p"></div>
                         <!-- Placeholder when nothing selected -->
                        <div id="sinCombo" class="text-center mt-5" style="display:none;"> <!-- Requires JS toggling logic, keeping simple structure for now -->
                             <div style="background: var(--light-bg); padding: 2rem; border-radius: 50%; width: 120px; height: 120px; margin: 0 auto 1.5rem; display: flex; align-items: center; justify-content: center;">
                                <i class="ti-arrow-circle-left text-primary" style="font-size: 3rem;"></i>
                            </div>
                            <h4 class="text-primary font-weight-bold">Seleccione un combo</h4>
                        </div>
                    </div>
                    <!-- Column -->
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal inmodal" id="modal-producto" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-producto" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_prod_producto" id="id_prod_producto">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Detalle del combo</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels">
                    <div class="col-md-12">
                        <div class="form-group display-flex m-b-10">
                            <input class="form-control input-lg input-mayus" type="text" autocomplete="off" placeholder="Nombre" name="nombre_producto" id="nombre_producto" required="required"/>
                            <span class="bar"></span>
                        </div>
                    </div>
                </div>
                <div class="row floating-labels m-t-40">
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <select class="selectpicker form-control" name="id_areap_producto" id="id_areap_producto" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" data-size="5" required="required">
                                <?php foreach($this->AreaProduccion as $key => $value): ?>
                                    <option value="<?php echo $value['id_areap']; ?>"><?php echo $value['nombre']; ?></option>
                                <?php endforeach; ?> 
                            </select>
                            <span class="bar"></span>
                            <label for="id_areap_producto">&Aacute;rea de producci&oacute;n <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Area donde se elabora el producto"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <input name="notas_producto" id="notas_producto" class="form-control" data-role="tagsinput" placeholder="add">
                            <span class="bar"></span>
                            <label for="notas_producto">Notas <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Escribe una o varias notas, Ejm: SIN SAL, POCA SAL"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <textarea name="descripcion_producto" id="descripcion_producto" class="form-control"></textarea>
                            <span class="bar"></span>
                            <label for="descripcion_producto">Descripci&oacute;n del producto <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Escribe una descripción breve del producto"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12 m-t-10">
                        <input type="hidden" name="hidden_estado_producto" id="hidden_estado_producto"/>
                         <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="estado_producto" id="estado_producto">
                            <label class="custom-control-label" for="estado_producto">Activo</label>
                        </div>
                    </div>
                    <div class="col-sm-12 m-t-10">
                        <input type="hidden" name="hidden_delivery_producto" id="hidden_delivery_producto"/>
                         <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="delivery_producto" id="delivery_producto">
                            <label class="custom-control-label" for="delivery_producto">Delivery</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal inmodal" id="modal-presentacion" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-presentacion" method="post" enctype="multipart/form-data">
        <input type="hidden" name="nombre_producto_presentacion" id="nombre_producto_presentacion">
        <input type="hidden" name="id_prod_presentacion" id="id_prod_presentacion">
        <input type="hidden" name="id_pres_presentacion" id="id_pres_presentacion">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Presentaci&oacute;n del combo</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row">
                    <div class="col-sm-5 b-r">
                        <div class="row m-t-20 m-b-20">
                            <div class="col-sm-12">
                                <div class="picture-container-modern" id="wizardProfile">
                                    <div class="picture">
                                        <img src="<?php echo URL; ?>public/img/productos/default.png" class="picture-src" id="wizardPicturePreview"/>
                                        <input type="hidden" name="imagen" id="imagen" value="default.png" />
                                        <input type="file" name="imagen" id="wizard-picture">
                                    </div>      
                                    <h6 class="text-center mt-3 text-primary pointer"><i class="ti-camera mr-1"></i> Cambiar Imagen</h6>
                                </div>
                            </div>
                        </div>
                        <div class="row floating-labels">
                            <div class="col-sm-6 m-t-40 m-b-20">
                                <input type="hidden" name="hidden_estado_presentacion" id="hidden_estado_presentacion"/>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="estado_presentacion" id="estado_presentacion">
                                    <label class="custom-control-label" for="estado_presentacion">Activo</label>
                                </div>
                            </div>
                            <div class="col-sm-6 m-t-40 m-b-20" id="tp-1" style="display: none">
                                <input type="hidden" name="hidden_receta_presentacion" id="hidden_receta_presentacion" value=""/>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="receta_presentacion" id="receta_presentacion">
                                    <label class="custom-control-label" for="receta_presentacion">Agregar Prod. <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Esta opción te permite agregar productos para armar el combo"></i></label>
                                </div>
                            </div>                
                            <div class="col-sm-6 m-t-40 m-b-20" id="tp-2" style="display: none">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="stock_presentacion" id="stock_presentacion">
                                    <label class="custom-control-label" for="stock_presentacion">Control Stock</label>
                                </div>
                            </div>
                            <div class="col-sm-6 m-b-20" id="">
                                <input type="hidden" name="hidden_impuesto_presentacion" id="hidden_impuesto_presentacion" value=""/>
                                <input type="hidden" name="igv_impuesto" id="igv_impuesto" value="<?php echo Session::get('igv'); ?>"/>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="impuesto_presentacion" id="impuesto_presentacion">
                                    <label class="custom-control-label" for="impuesto_presentacion">Impuesto <?php echo Session::get('impAcr'); ?> <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Esta opción te permite trabajar con productos exonerados a impuestos."></i></label>
                                </div>
                            </div>
                            <div class="col-sm-6 m-t-0">
                                <input type="hidden" name="hidden_delivery_presentacion" id="hidden_delivery_presentacion"/>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="delivery_presentacion" id="delivery_presentacion">
                                    <label class="custom-control-label" for="delivery_presentacion">Delivery <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="¿Deseas mostrar esta presentación en tus deliverys?"></i></label>
                                </div>
                            </div>
                            <input type="hidden" name="hidden_stock_limit" id="hidden_stock_limit" value="0"/>
                            <input type="hidden" name="hidden_insumo_principal_presentacion" id="hidden_insumo_principal_presentacion" value="0" />
                        </div>
                    </div>
                    <div class="col-sm-7">
                        <div class="row floating-labels">
                            <div class="col-md-12">
                                <div class="form-group m-b-40 letNumMayMin">
                                    <input class="form-control input-lg input-mayus" type="text" autocomplete="off" name="presentacion_presentacion" id="presentacion_presentacion" placeholder="Nombre" required="required"/>
                                    <span class="bar"></span>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group m-b-40">
                                    <textarea name="descripcion_presentacion" id="descripcion_presentacion" class="form-control"></textarea>
                                    <span class="bar"></span>
                                    <label for="descripcion_presentacion">Descripci&oacute;n de la presentaci&oacute;n <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Escribe una descripción breve de la presentación"></i></label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group f m-b-40 letNumMayMin">
                                    <input type="text" class="form-control input-mayus cbu" name="cod_prod_presentacion" id="cod_prod_presentacion" autocomplete="off" required>
                                    <span class="bar"></span>
                                    <label for="cod_prod_presentacion">C&oacute;digo</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group f m-b-40 dec">
                                    <input type="text" class="form-control cbu" name="precio_presentacion" id="precio_presentacion" autocomplete="off" required>
                                    <span class="bar"></span>
                                    <label for="precio_presentacion">Precio venta - <?php echo Session::get('moneda'); ?></label>
                                </div>
                            </div>
                            <div class="col-sm-6" id="tp-3" style="display: none">
                                <div class="form-group f m-b-40 dec">
                                    <input type="text" class="form-control cbu" name="precio_delivery" id="precio_delivery" autocomplete="off">
                                    <span class="bar"></span>
                                    <label for="precio_delivery">Precio delivery - <?php echo Session::get('moneda'); ?> <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Cantidad monetaria que se vende esta presentación solo para deliverys"></i></label>
                                </div>
                            </div>
                            <div class="col-sm-6" id="tp-4" style="display: none">
                                <div class="form-group m-b-40 ent">
                                    <input type="text" name="stock_min_presentacion" id="stock_min_presentacion" class="form-control cbu"autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="stock_min_presentacion">Stock m&iacute;nimo <i class="ti-info-alt text-warning font-10" data-toggle="tooltip" title="Considere este valor para el control de stock"></i></label>
                                </div>
                            </div>
                        </div>
                        <div id="mensaje-ins" style="margin-bottom: 10px"></div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>
<div class="modal inmodal" id="modal-receta" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-receta" method="post" class="form-receta">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Detalle de los productos</h4>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels m-t-0">
                    <div class="col-sm-12">
                        <div class="form-group m-b-0 form-group-modern">
                            <input type="text" name="buscar_ingrediente" id="buscar_ingrediente" class="form-control bg-t" autocomplete="off" placeholder="Búsqueda..."/>
                            <span class="bar"></span>
                            <label for="buscar_ingrediente"><i class="fa fa-search"></i> Buscar Producto</label>
                        </div>
                    </div>
                </div>
            </div>
            <div><hr class="m-t-0 m-b-0"></div>
            <div class="modal-body list-ingredientes" style="display: none">
                <ul class="list-group">
                    <li class="list-group-item" style="background:#f1f1f1; font-size: 14px;">
                        <label>Producto:</label> <span id="insumo"></span> - <label>Unidad de Medida:</label> <span class="badge badge-warning" id="medida"></span>
                    </li>
                    <li class="list-group-item floating-labels">
                        <div class="row" style="margin-bottom: -14px">
                            <input type="hidden" name="id_pres_receta" id="id_pres_receta"/>
                            <input type="hidden" name="id_ins_receta" id="id_ins_receta"/>
                            <input type="hidden" name="id_tipo_ins_receta" id="id_tipo_ins_receta"/>
                            <div class="col-sm-2 ent">
                                <div class="form-group m-b-0">
                                    <input type="text" name="cant_receta" id="cant_receta" class="form-control" style="text-align: center;" autocomplete="off" />
                                    <span class="bar"></span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <select name="id_med_receta" id="id_med_receta" class="selectpicker form-control" data-live-search="true" autocomplete="off" data-size="5">
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <small>Equivale a:<br><strong><span id="valor_ing">0</span> - <span id="desc_medida"></span></strong></small>
                            </div>
                            <div class="col-sm-3">
                                <div class="text-right">
                                    <button type="submit" class="btn btn-sm btn-circle btn-orange btn-modern-success"><i class="ti-plus"></i></button>
                                    <button type="button" class="btn btn-sm btn-danger btn-eliminar btn-modern"><i class="fa fa-trash"></i></button>
                                </div>
                            </div>
                        </div> 
                    </li>
                </ul>
            </div>
            <div class="list-ingredientes" style="display: none"><hr class="m-t-0 m-b-0"></div>
        </form>
            <div class="modal-body p-0">
                <div class="table-responsive scroll_receta">   
                    <table class="table table-modern m-l-0 m-r-0" width="100%">
                        <thead>
                            <tr>
                                <th>Tipo</th>
                                <th>Nombre</th>                                    
                                <th>Cantidad</th>
                                <th>Unidad Medida</th>
                                <th class="text-right">Acciones</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st" id="table-receta"></tbody>
                    </table>   
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary btn-cerrar-receta" data-dismiss="modal">Aceptar</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(function() {
    $('#config').addClass("active");
    function filterGlobal () {
    $('#table-productos').DataTable().search( 
        $('#global_filter').val()
    ).draw();
    }
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    } );
});
</script>
