<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === TABS MODERNOS === */
.nav-tabs-modern {
    border-bottom: 2px solid #e9ecef;
    margin-bottom: 0;
}

.nav-tabs-modern .nav-link {
    border: none;
    color: #6c757d;
    font-weight: 500;
    padding: 1rem 1.5rem;
    position: relative;
    transition: var(--transition);
}

.nav-tabs-modern .nav-link:hover {
    color: var(--primary-color);
    background: transparent;
}

.nav-tabs-modern .nav-link.active {
    color: var(--primary-color);
    background: transparent;
    border-bottom: 3px solid var(--primary-color);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === TABLA MODERN === */
.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.005);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === SIDEBAR CATEGORIES === */
.sidebar-modern .list-group-item {
    border: none;
    padding: 0.75rem 1rem;
    margin-bottom: 0.5rem;
    border-radius: 8px;
    transition: var(--transition);
    color: #6c757d;
    background: transparent;
}

.sidebar-modern .list-group-item:hover,
.sidebar-modern .list-group-item.active {
    background: rgba(86, 100, 210, 0.1);
    color: var(--primary-color);
    font-weight: 600;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}
/* === RESPONSIVE UTILS === */
@media (max-width: 768px) {
    .nav-tabs-modern {
        flex-wrap: nowrap !important;
        overflow-x: auto;
        overflow-y: hidden;
        -webkit-overflow-scrolling: touch;
        justify-content: flex-start !important;
        padding-bottom: 5px;
    }
    
    .nav-tabs-modern .nav-item {
        white-space: nowrap;
    }

    .nav-tabs-modern .nav-link {
        padding: 0.8rem 1rem;
        font-size: 0.9rem;
    }

    #ul-cat {
        max-height: 250px !important;
    }
}

/* === INTERNAL FORM DEEP MODERNIZATION === */
/* File Upload Box (Rectangular) */
.file-upload-modern {
    position: relative;
    padding: 2rem;
    border: 2px dashed #dce2e6;
    border-radius: 12px;
    text-align: center;
    background: #f8f9fa;
    cursor: pointer;
    transition: all 0.3s ease;
    width: 100%;
    margin-top: 10px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
}
.file-upload-modern:hover {
    border-color: var(--primary-color);
    background: white;
    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
}
.file-upload-modern i {
    font-size: 2.5rem;
    color: #adb5bd;
    margin-bottom: 1rem;
    transition: color 0.3s;
}
.file-upload-modern:hover i {
    color: var(--primary-color);
}
.file-upload-modern span {
    color: #6c757d;
    font-weight: 500;
}
</style>

<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Restaurante</a></span>
            <span class="breadcrumb-item active">Insumos</span>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-3">
        <div class="card card-modern h-100">         
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h4 class="card-title text-primary font-weight-bold"><i class="ti-menu font-18 mr-2"></i> Categorías</h4>
                    <div id="step1">
                         <button type="button" class="btn btn-sm btn-modern btn-modern-success btn-circle btn-nuevo-categoria"><i class="ti-plus"></i></button>
                    </div>
                </div>
                
                <ul class="list-style-none sidebar-modern">
                    <li class="list-group-item"><a href="javascript:void(0)" class="link text-dark font-weight-bold" onclick="listarInsumos('%')"><i class="mdi mdi-all-inclusive mr-2"></i> Todos</a></li>
                </ul>
                <form id="frm-categoria" method="post" enctype="multipart/form-data">
                <input type="hidden" name="id_catg_categoria" id="id_catg_categoria">
                <div id="nueva-catg" style="display: none" class="animate-in bg-light p-3 rounded mb-3">
                    <ul class="list-style-none">
                        <li class="divider"></li>
                    </ul>
                    <div class="row floating-labels m-t-20">
                        <div class="col-sm-12">
                            <div class="form-group f m-b-20 letNumMayMin form-group-modern">
                                <input type="text" class="form-control input-mayus cbu ph-0" name="descripcion_categoria" id="descripcion_categoria" autocomplete="off" onkeyup="mayus(this);" required>
                                <span class="bar"></span>
                                <label for="descripcion_categoria">Nombre</label>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-6 m-b-10">
                            <a class="btn btn-secondary btn-block btn-ccatg btn-modern">Cancelar</a>
                        </div>
                        <div class="col-6 m-b-10 text-right">
                            <button type="submit" class="btn btn-block btn-success btn-modern btn-modern-success">Aceptar</button>
                        </div>
                    </div>
                </div>
                </form>
                <div class="scroll_categoria sidebar-modern" id="ul-cat" style="max-height: 500px; overflow-y: auto;"></div>
            </div>
        </div>
    </div>
    <div class="col-lg-9">
        <div class="card card-modern h-100">
            <div class="card-body p-0">
                <div class="p-4 border-bottom">
                     <ul class="nav nav-tabs nav-tabs-modern justify-content-center" role="tablist">
                         <li class="nav-item">
                            <a href="producto" class="nav-link">
                                <i class="mdi mdi-food-fork-drink font-18 mr-2"></i> Platos y bebidas
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="combo" class="nav-link">
                                <i class="mdi mdi-food font-18 mr-2"></i> Combos
                            </a>                        
                        </li>
                        <li class="nav-item">
                            <a href="insumo" class="nav-link active">
                                <i class="mdi mdi-food-variant font-18 mr-2"></i> Insumos
                            </a>
                        </li>
                    </ul>
                </div>
                
                <div class="row px-4 pb-2 pt-4 floating-labels">
                    <div class="col-lg-3 mb-3 mb-sm-0">
                        <button class="btn btn-primary btn-block btn-importar-producto btn-modern" id="step2"><i class="ti-upload mr-1"></i> Importar</button>
                    </div>
                    <div class="col-lg-5 mb-3">
                        <button class="btn btn-success btn-block btn-nuevo-insumo btn-modern btn-modern-success" id="step2"><i class="fa fa-plus-circle mr-1"></i> Nuevo insumo</button>
                    </div>
                    <div class="col-lg-4" id="filter_global">
                        <div class="form-group m-b-0 form-group-modern">
                            <input class="form-control global_filter" id="global_filter" type="text" placeholder="Buscar insumo...">
                            <span class="bar"></span>
                            <label for="global_filter"><i class="fa fa-search mr-1"></i> Buscar insumo</label>
                        </div>
                    </div>
                </div>

                <div class="table-responsive b-t m-t-10 px-4">
                    <table class="table table-hover table-modern" width="100%" id="table-insumos">
                        <thead class="table-head">
                            <th width="10%">Código</th>
                            <th width="">Nombre</th>
                            <th width="20%">Categoría</th>
                            <th width="10%">Unidad</th>
                            <th width="5%">Costo</th>
                            <th width="10%" class="text-right">¿Activo?</th>
                            <th width="5%"></th>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal inmodal" id="modal-insumo" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog" style="max-width:400px;">
        <div class="modal-content animated bounceInRight modal-content-modern">
        <form id="form-insumo" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_ins" id="id_ins">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Detalle del insumo</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels">
                    <div class="col-md-12">
                        <div class="form-group m-b-40 letNumMayMin">
                            <input class="form-control input-lg input-mayus" type="text" autocomplete="off" name="nomb_ins" id="nomb_ins" placeholder="Nombre" required="required"/>
                            <span class="bar"></span>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group f m-b-40 letNumMayMin">
                            <input type="text" class="form-control input-mayus cbu" name="cod_ins" id="cod_ins" onkeyup="mayus(this);" autocomplete="off">
                            <span class="bar"></span>
                            <label for="cod_ins">C&oacute;digo</label>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group m-b-40">
                            <select class="selectpicker form-control cbu" name="id_med" id="id_med" data-style="form-control btn-default" autocomplete="off" required="required" title="Seleccionar" data-size="5">
                                <?php foreach($this->UnidadMedida as $key => $value): ?>
                                    <option value="<?php echo $value['id_med']; ?>"><?php echo $value['descripcion']; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <span class="bar"></span>
                            <label for="id_med">Unidad de medida</label>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group f m-b-40 cbu">
                            <input type="hidden" id="categoria"/>
                            <select class="selectpicker form-control" name="id_catg" id="id_catg" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" data-size="5" required="required">  
                            </select>
                            <span class="bar"></span>
                            <label for="id_catg">Categor&iacute;a</label>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group f m-b-40 dec">
                            <input type="text" class="form-control cbu" name="cos_uni" id="cos_uni" autocomplete="off" required="required">
                            <span class="bar"></span>
                            <label for="cos_uni">Costo Unitario</label>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group f m-b-20 dec">
                            <input type="text" class="form-control cbu" name="stock_min" id="stock_min" autocomplete="off">
                            <span class="bar"></span>
                            <label for="stock_min">Stock m&iacute;nimo <i class="ti-info-alt text-warning font-10" data-original-title="Considere este valor según unidad de medida" data-toggle="tooltip" data-placement="top"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group m-b-20">
                            <select class="selectpicker form-control" name="estado" id="estado" data-style="form-control btn-default" autocomplete="off">
                                <option value="a" active>ACTIVO</option>
                                <option value="i">INACTIVO</option>  
                            </select>
                            <span class="bar"></span>
                            <label for="estado">Estado</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="submit" class="btn btn-success btn-guardar btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>


<!-- modal import -->

<div class="modal inmodal" id="modal-import" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-import" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_prod_producto" id="id_prod_producto">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">IMPORTAR PRODUCTOS</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels">
                    <div class="col-md-12">
                        <span class="ont-12">
                            Desde aquí puedes importar nuevos productos:
                        </span>
                    </div>                    
                </div>
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div id="yourBtn" class="file-upload-modern" onclick="getFile()">
                            <i class="ti-cloud-up"></i>
                            <span>Haga clic para seleccionar un archivo (.xlsx)</span>
                        </div>
                        <div style='height: 0px;width: 0px; overflow:hidden;'>
                            <input id="upfile" type="file" value="upload" onchange="sub(this) " accept=".xls,.xlsx" />
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12 text-center">
                    <a class="text-primary font-12 font-weight-bold" href="<?php echo URL; ?>/public/excel/insumos.xlsx"><i class="ti-download mr-1"></i> Descargar formato de ejemplo para importar</a>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<!--fin -->
<!--fin -->
<script type="text/javascript">

function getFile() {
  document.getElementById("upfile").click();
}

function sub(obj) {
  var file = obj.value;
  var fileName = file.split("\\");
  document.getElementById("yourBtn").innerHTML = fileName[fileName.length - 1];
  document.myForm.submit();
  event.preventDefault();
}

$(function() {
    $('#config').addClass("active");
    function filterGlobal () {
$('#table-insumos').DataTable().search( 
$('#global_filter').val()
).draw();
    }
    $('input.global_filter').on( 'keyup click', function () {
filterGlobal();
});
});
</script>
