<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === TABLA MODERN === */
.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.005);
}

    .table-modern tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    /* === ANIMACIONES === */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .animate-in {
        animation: fadeInUp 0.5s ease;
    }

    /* === MODAL MODERN === */
    .modal-content-modern {
        border-radius: 16px;
        border: none;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    .modal-header-modern {
        background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
        color: white;
        border-bottom: none;
        padding: 1.5rem;
    }
    .modal-header-modern .close {
        color: white;
        opacity: 0.8;
        padding: 1rem;
        margin: -1rem -1rem -1rem auto;
    }
    .modal-header-modern .close:hover {
        opacity: 1;
    }
    .modal-body-modern {
        padding: 2rem;
        background: #f8f9fa;
    }
    .modal-footer-modern {
        background: #f8f9fa;
        border-top: none;
        padding: 1.5rem 2rem;
    }

    /* === FORMULARIO MODERN === */
    .form-group-modern {
        position: relative;
        margin-bottom: 25px;
    }
    
    .form-group-modern input.form-control,
    .form-group-modern select.form-control,
    .form-group-modern textarea.form-control {
        border: none;
        border-bottom: 2px solid #e9ecef;
        border-radius: 0;
        padding: 10px 0;
        background: transparent;
        font-weight: 500;
        transition: all 0.3s;
        box-shadow: none;
    }

    .form-group-modern .bootstrap-select > .dropdown-toggle {
        border: none;
        border-bottom: 2px solid #e9ecef;
        background: transparent !important;
        box-shadow: none !important;
        padding: 10px 0;
        border-radius: 0;
    }

    .form-group-modern input.form-control:focus,
    .form-group-modern select.form-control:focus,
    .form-group-modern textarea.form-control:focus,
    .form-group-modern .filter-option {
        border-bottom-color: var(--primary-color);
    }

    .form-group-modern label {
        color: #adb5bd;
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s;
        margin-bottom: 5px;
        display: block;
    }

    .form-group-modern input:focus ~ label,
    .form-group-modern input:valid ~ label,
    .form-group-modern textarea:focus ~ label,
    .form-group-modern textarea:valid ~ label {
        color: var(--primary-color);
        font-weight: 600;
    }
    
    /* FORCE TABLE HEADER STYLE */
    .table-modern thead th {
        background-color: #667eea !important; /* Fallback */
        background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%) !important;
        color: white !important;
        border: none !important;
    }
</style>

<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Restaurante</a></span>
            <span class="breadcrumb-item active">Salones y mesas</span>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-4 mb-3 mb-lg-0">
        <div class="card card-modern h-100">         
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title text-primary font-weight-bold"><i class="ti-home font-18 mr-2"></i> Salones</h4>
                    <button type="button" class="btn btn-success btn-modern btn-modern-success btn-circle" onclick="editarSalon();"><i class="ti-plus"></i></button>
                </div>
                
                 <div class="row floating-labels mb-2">
                    <div class="col-sm-12">
                        <div class="form-group m-b-10 form-group-modern">
                            <input type="text" class="form-control global_filter_01" id="global_filter_01" autocomplete="off" placeholder="Buscar...">
                            <span class="bar"></span>
                            <label for="global_filter_01"><i class="fa fa-search mr-1"></i> Buscar</label>
                        </div>
                    </div>
                </div>

                <div class="table-responsive b-t m-b-10 table-responsive-modern">
                    <table id="table01" class="table table-hover table-modern" cellspacing="0" width="100%">
                        <thead class="table-head">
                            <th>Nombre</th>
                            <th width="10%" class="text-center">Mesas</th>
                            <th width="10%" class="text-center">Estado</th>
                            <th class="text-right" width="10%">Acciones</th>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card card-modern h-100" id="lizq-s" style="display: block;">         
            <div class="card-body d-flex align-items-center justify-content-center" style="min-height: 400px; background: var(--light-bg); border-radius: 12px;">
                <div class="text-center animate-in">
                    <div style="background: white; padding: 2rem; border-radius: 50%; width: 150px; height: 150px; margin: 0 auto 1.5rem; display: flex; align-items: center; justify-content: center; box-shadow: var(--card-shadow);">
                        <i class="ti-arrow-circle-left text-primary" style="font-size: 4rem;"></i>
                    </div>
                    <h3 class="mt-3 font-weight-bold text-primary">Agregue o seleccione un salón</h3>
                    <p class="text-muted">Debes agregar o seleccionar un salón para poder agregar, modificar o visualizar sus mesas</p>
                </div>
            </div>
        </div>
        <div class="card card-modern h-100" id="lizq-i" style="display: none;">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title text-primary font-weight-bold">Mesa(s) de <span id="title-mesa" class="font-weight-bold"></span></h4>
                    <div id="btn-nuevo"></div>
                </div>
                
                <div class="row floating-labels mb-2">
                    <div class="col-sm-5 offset-sm-7">
                        <div class="form-group m-t-20 m-b-10 form-group-modern">
                            <input type="text" class="form-control global_filter_02" id="global_filter_02" autocomplete="off" placeholder="Buscar mesa...">
                            <span class="bar"></span>
                            <label for="global_filter_02"><i class="fa fa-search mr-1"></i> Buscar mesa</label>
                        </div>
                    </div>
                </div>

                <div class="table-responsive b-t m-b-10 table-responsive-modern">
                    <table id="table02" class="table table-hover table-modern" cellspacing="0" width="100%">
                        <thead class="table-head">
                            <th>Nombre</th>
                            <th>Salón</th>
                            <th>Forma</th>
                            <th>Estado</th>
                            <th class="text-right">Acciones</th>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="card card-modern text-center " id="ordenar-m" style="display: none; height: 100%; width: 100%">        
            <div class="card-body" style="height: 98%; width: 97%; ">
                <div id="contenedor_mesas" style="height: 95%; width: 97%; border: 1px solid #e9ecef; border-radius: 8px; background: #f8f9fa;"></div>
                <button class="btn btn-info mt-3 btn-modern"><i class="fa fa-save"></i> Guardar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal inmodal" id="modal01" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight modal-content-modern">
        <form id="form01" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_salon" id="id_salon">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Salón</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels p-2">
                    <div class="col-sm-12">
                        <div class="form-group f m-b-40 letNumMayMin form-group-modern">
                            <input type="text" class="form-control" name="descripcion" id="descripcion" autocomplete="off" required>
                            <span class="bar"></span>
                            <label for="descripcion">Nombre</label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40 form-group-modern">
                            <select class="selectpicker form-control" name="estado" id="estado" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true">
                                <option value="a" active>ACTIVO</option>
                                <option value="i">INACTIVO</option>  
                            </select>
                            <span class="bar"></span>
                            <label for="estado">Estado</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>
<div class="modal inmodal" id="modal02" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight modal-content-modern">
        <form id="form02" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_mesa" id="id_mesa">
        <input type="hidden" name="id_salon_1" id="id_salon_1">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Mesa</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels p-2">
                    <div class="col-sm-12">
                        <div class="form-group f m-b-40 letNumMayMin form-group-modern">
                            <input type="text" class="form-control" name="nro_mesa" id="nro_mesa" autocomplete="off" required>
                            <span class="bar"></span>
                            <label for="nro_mesa">Nombre</label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40 form-group-modern">
                            <select class="selectpicker form-control" name="forma" id="forma" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true">
                                <option value="1" active>Cuadrado</option>
                                <option value="2">Redondo</option>  
                            </select>
                            <span class="bar"></span>
                            <label for="forma">Forma</label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40 form-group-modern">
                            <select class="selectpicker form-control" name="estado_1" id="estado_1" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true">
                                <option value="a" active>ACTIVO</option>
                                <option value="m">INACTIVO</option>  
                            </select>
                            <span class="bar"></span>
                            <label for="estado_1">Estado</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<style type="text/css">
    .canvas-container {
  margin-right: auto;
  margin-left: auto;
  background-color: #fff
}
</style>

<!-- Using absolute URL constant if available, otherwise relative -->
<script src="<?php echo URL; ?>public/plugins/jquery/jquery.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo URL; ?>public/plugins/jquery-ui-1.12.1/jquery-ui.css">
<script src="<?php echo URL; ?>public/plugins/jquery-ui-1.12.1/jquery-ui.js"></script>
