<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD MODERN === */
.card-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    transition: var(--transition);
}

.card-modern:hover {
    box-shadow: var(--card-shadow-hover);
}

/* === BUTTONS MODERN === */
.btn-modern {
    border-radius: 8px;
    font-weight: 500;
    padding: 0.6rem 1.2rem;
    box-shadow: 0 4px 6px rgba(50, 50, 93, 0.11), 0 1px 3px rgba(0, 0, 0, 0.08);
    transition: var(--transition);
    border: none;
}

.btn-modern:hover {
    transform: translateY(-1px);
    box-shadow: 0 7px 14px rgba(50, 50, 93, 0.1), 0 3px 6px rgba(0, 0, 0, 0.08);
}

.btn-modern-primary {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
}

.btn-modern-success {
    background: linear-gradient(135deg, var(--success-color) 0%, #2ecc71 100%);
    color: white;
}

/* === TABLA MODERN === */
.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    background-color: #667eea !important; /* Fallback */
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%) !important;
    color: white !important;
    border: none !important;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.005);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === MODAL MODERN === */
.modal-content-modern {
    border-radius: 16px;
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    overflow: hidden;
}
.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
    border-bottom: none;
    padding: 1.5rem;
}
.modal-header-modern .close {
    color: white;
    opacity: 0.8;
    padding: 1rem;
    margin: -1rem -1rem -1rem auto;
}
.modal-header-modern .close:hover {
    opacity: 1;
}
.modal-body-modern {
    padding: 2rem;
    background: #f8f9fa;
}
.modal-footer-modern {
    background: #f8f9fa;
    border-top: none;
    padding: 1.5rem 2rem;
}

/* === FORMULARIO MODERN === */
.form-group-modern {
    position: relative;
    margin-bottom: 25px;
}

.form-group-modern input.form-control,
.form-group-modern select.form-control,
.form-group-modern textarea.form-control {
    border: none;
    border-bottom: 2px solid #e9ecef;
    border-radius: 0;
    padding: 10px 0;
    background: transparent;
    font-weight: 500;
    transition: all 0.3s;
    box-shadow: none;
}

.form-group-modern .bootstrap-select > .dropdown-toggle {
    border: none;
    border-bottom: 2px solid #e9ecef;
    background: transparent !important;
    box-shadow: none !important;
    padding: 10px 0;
    border-radius: 0;
}

.form-group-modern input.form-control:focus,
.form-group-modern select.form-control:focus,
.form-group-modern textarea.form-control:focus,
.form-group-modern .filter-option {
    border-bottom-color: var(--primary-color);
}

.form-group-modern label {
    color: #adb5bd;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s;
    margin-bottom: 5px;
    display: block;
}

.form-group-modern input:focus ~ label,
.form-group-modern input:valid ~ label,
.form-group-modern textarea:focus ~ label,
.form-group-modern textarea:valid ~ label {
    color: var(--primary-color);
    font-weight: 600;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}
</style>

<div class="row page-titles-modern animate-in">
    <div class="col-md-5 align-self-center">
        <h4 class="text-white">Ajustes</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste"><i class="fa fa-home mr-1"></i>Inicio</a></span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste">Empresa</a></span>
            <span class="breadcrumb-item active">Tipos de pago</span>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <div class="card card-modern h-100">         
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="card-title text-primary font-weight-bold"><i class="ti-credit-card font-18 mr-2"></i> Tipos de Pago</h4>
                    <a href="javascript:void(0)" class="btn btn-success btn-nuevo btn-modern btn-modern-success"><i class="ti-plus mr-1"></i> Nuevo Tipo</a>
                </div>
                
                 <div class="row floating-labels mb-2">
                    <div class="col-sm-12 col-lg-6 offset-lg-6">
                        <div class="form-group m-b-10 form-group-modern">
                            <input type="text" class="form-control global_filter" id="global_filter" autocomplete="off" placeholder="Buscar...">
                            <span class="bar"></span>
                            <label for="global_filter"><i class="fa fa-search mr-1"></i> Buscar</label>
                        </div>
                    </div>
                </div>

                <div class="table-responsive b-t m-b-10 table-responsive-modern">
                    <table id="table" class="table table-hover table-modern" cellspacing="0" width="100%">
                        <thead class="table-head">
                            <th>Nombre</th>
                            <th>Tipo</th>
                            <!-- <th>Delivery</th> -->
                            <th>Estado</th>
                            <th class="text-right">Acciones</th>
                        </thead>
                        <tbody class="tb-st"></tbody>
                    </table>
                </div>          
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card card-modern h-100 p-20 alert-info border-0 shadow-sm" style="background-color: #e1f5fe;">
            <h4 class="card-title text-info font-weight-bold"><i class="fa fa-exclamation-circle mr-2"></i> Información</h4>
            <div class="font-13" style="color: #455a64!important;">
                <dl>
                    <dt>Tipos de pago</dt>
                    <dd>Permite crear tipos de pago que a su vez se le debe asignar una categoria sobre la cual debería reflejarse.</dd>
                </dl>
            </div>
        </div>
    </div>
</div>

<div class="modal inmodal" id="modal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight modal-content-modern">
        <form id="form" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_pago" id="id_pago">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title"></h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="row floating-labels p-2">
                    <div class="col-sm-12">
                        <div class="form-group letNumMayMin f m-b-40 form-group-modern">
                            <input type="text" class="form-control input-mayus" name="nombre" id="nombre" value="" autocomplete="off" required>
                            <span class="bar"></span>
                            <label for="nombre">Nombre</label>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40 form-group-modern">
                            <select class="selectpicker form-control" name="id_tipo_pago" id="id_tipo_pago" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" autocomplete="off" required="required">
                            <?php foreach($this->TipoPago as $key => $value): ?>
                                <option value="<?php echo $value['id_pago']; ?>"><?php echo $value['descripcion']; ?></option>
                            <?php endforeach; ?>
                            </select>
                            <span class="bar"></span>
                            <label for="id_tipo_pago">Tipo</label>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group m-b-40 form-group-modern">
                            <select class="selectpicker form-control" name="estado" id="estado" data-style="form-control btn-default">
                                <option value="a" active>ACTIVO</option>
                                <option value="i">INACTIVO</option>  
                            </select>
                            <span class="bar"></span>
                            <label for="estado">Estado</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-modern btn-modern-success">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>