<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 4px 20px rgba(0,0,0,0.05);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MODERN === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
    transition: color 0.2s;
}

.breadcrumb-modern a:hover {
    color: white;
    text-decoration: underline;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === OPTION CARDS === */
.card-modern {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    border: none;
    margin-bottom: 1.5rem;
    transition: var(--transition);
    overflow: hidden;
}

.card-heading {
    padding: 1.25rem 1.5rem;
    background: #fff;
    border-bottom: 1px solid #f0f0f0;
    font-weight: 700;
    color: var(--dark-color);
    font-size: 1.1rem;
}

.option-list {
    padding: 0;
    list-style: none;
    margin: 0;
}

.option-item {
    padding: 1rem 1.5rem;
    display: flex;
    align-items: flex-start;
    border-bottom: 1px solid #f8f9fa;
    transition: var(--transition);
    text-decoration: none !important;
}

.option-item:last-child {
    border-bottom: none;
}

.option-item:hover {
    background-color: #f8f9fa;
    transform: translateX(5px);
}

.option-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%; /* Circular */
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.2rem;
    margin-right: 1rem;
    flex-shrink: 0;
}

.icon-warning { background: linear-gradient(135deg, #fce38a 0%, #f38181 100%); }
.icon-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
.icon-success { background: linear-gradient(135deg, #42e695 0%, #3bb2b8 100%); }
.icon-danger { background: linear-gradient(135deg, #ff9a9e 0%, #fecfef 99%, #fecfef 100%); }


.option-content h5 {
    font-weight: 600;
    color: var(--dark-color);
    margin-bottom: 0.25rem;
    font-size: 1rem;
}

.option-content span {
    font-size: 0.85rem;
    color: #8898aa;
    line-height: safe;
}

.animate-in { animation: fadeInUp 0.5s ease; }
@keyframes fadeInUp { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }

/* === MODAL MODERN === */
.modal-content-modern {
    border-radius: 16px;
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    overflow: hidden;
}
.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
    border-bottom: none;
    padding: 1.5rem;
}
.modal-header-modern .close {
    color: white;
    opacity: 0.8;
    padding: 1rem;
    margin: -1rem -1rem -1rem auto;
}
.modal-header-modern .close:hover {
    opacity: 1;
}
.modal-body-modern {
    padding: 2rem;
    background: #f8f9fa;
}
.modal-footer-modern {
    background: #f8f9fa;
    border-top: none;
    padding: 1.5rem 2rem;
}

/* === FORMULARIO MODERN === */
.form-group-modern {
    position: relative;
    margin-bottom: 25px;
}

.form-group-modern input.form-control,
.form-group-modern select.form-control,
.form-group-modern textarea.form-control {
    border: none;
    border-bottom: 2px solid #e9ecef;
    border-radius: 0;
    padding: 10px 0;
    background: transparent;
    font-weight: 500;
    transition: all 0.3s;
    box-shadow: none;
}

.form-group-modern input.form-control:focus,
.form-group-modern select.form-control:focus,
.form-group-modern textarea.form-control:focus {
    border-bottom-color: var(--primary-color);
}

.form-group-modern label {
    color: #adb5bd;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s;
    margin-bottom: 5px;
    display: block;
}

.form-group-modern input:focus ~ label,
.form-group-modern input:valid ~ label,
.form-group-modern textarea:focus ~ label,
.form-group-modern textarea:valid ~ label {
    color: var(--primary-color);
    font-weight: 600;
}

/* === SWITCH MODERN === */
.switch label {
    cursor: pointer;
    margin: 0;
    padding: 0;
}
.switch label input[type=checkbox] {
    opacity: 0;
    width: 0;
    height: 0;
    margin: 0;
}
.switch label .lever {
    content: "";
    display: inline-block;
    position: relative;
    width: 44px;
    height: 24px;
    background-color: #e9ecef;
    border-radius: 20px;
    transition: background 0.3s;
    vertical-align: middle;
}
.switch label .lever:after {
    content: "";
    position: absolute;
    width: 18px;
    height: 18px;
    background-color: #fff;
    border-radius: 50%;
    left: 4px;
    top: 3px;
    transition: left 0.3s, background-color 0.3s, box-shadow 0.1s;
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}
.switch label input[type=checkbox]:checked + .lever {
    background-color: #c9d0ff; /* Lighter primary */
}
.switch label input[type=checkbox]:checked + .lever:after {
    left: 22px;
    background-color: var(--primary-color);
}
</style>

<input type="hidden" id="bloqueo_id" value="<?php print (Session::get('bloqueo_id')); ?>"/>

<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fa fa-cogs mr-2"></i>Panel de Configuración</h4>
        <div class="breadcrumb-modern">
            <a href="<?php echo URL; ?>ajuste" class="breadcrumb-item"><i class="fa fa-home mr-1"></i>Inicio</a>
            <span class="breadcrumb-item active">Panel de Opciones</span>
        </div>
    </div>
</div>

<div class="wrapper wrapper-content animated fadeIn ng-scope">
    <div class="row">
        <!-- SYSTEM SETTINGS -->
        <div class="col-lg-4">
            <div class="card card-modern animate-in" style="animation-delay: 0.1s;">
                <div class="card-heading text-warning"><i class="ti-server mr-2"></i>Sistema</div>
                <div class="option-list">
                    <a href="ajuste/sistema" class="option-item">
                        <div class="option-icon icon-warning"><i class="fa fa-cog"></i></div>
                        <div class="option-content">
                            <h5>Configuración Inicial</h5>
                            <span>Características, opciones y parámetros globales.</span>
                        </div>
                    </a>
                    <a href="ajuste/printer" class="option-item">
                        <div class="option-icon icon-warning"><i class="ti-printer"></i></div>
                        <div class="option-content">
                            <h5>Impresoras</h5>
                            <span>Gestión de impresoras y tickets.</span>
                        </div>
                    </a>
                    <?php if (Session::get('rol') == 1):?> 
                    <a href="ajuste/optimizar" class="option-item">
                        <div class="option-icon icon-warning"><i class="ti-rocket"></i></div>
                        <div class="option-content">
                            <h5>Optimización</h5>
                            <span>Mantenimiento y limpieza de datos.</span>
                        </div>
                    </a>
                    <a href="javascript:void(0)" class="btn-plataforma option-item">
                        <div class="option-icon icon-warning"><i class="ti-shield"></i></div>
                        <div class="option-content">
                            <h5>Ajustes Plataforma</h5>
                            <span>Administración y seguridad.</span>
                        </div>
                    </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- COMPANY SETTINGS -->
        <div class="col-lg-4">
            <div class="card card-modern animate-in" style="animation-delay: 0.2s;">
                <div class="card-heading text-primary"><i class="mdi mdi-domain mr-2"></i>Empresa</div>
                <div class="option-list">
                    <a href="ajuste/datosempresa" class="option-item">
                        <div class="option-icon icon-primary"><i class="ti-briefcase"></i></div>
                        <div class="option-content">
                            <h5>Datos de Empresa</h5>
                            <span>Razón social, dirección, logo.</span>
                        </div>
                    </a>
                    <a href="ajuste/usuario" class="option-item">
                        <div class="option-icon icon-primary"><i class="ti-user"></i></div>
                        <div class="option-content">
                            <h5>Usuarios y Roles</h5>
                            <span>Gestión de personal y permisos.</span>
                        </div>
                    </a>
                    <a href="ajuste/tipodoc" class="option-item">
                        <div class="option-icon icon-primary"><i class="mdi mdi-file-document"></i></div>
                        <div class="option-content">
                            <h5>Tipos de Documento</h5>
                            <span>Series y correlativos.</span>
                        </div>
                    </a>
                    <a href="ajuste/tipopago" class="option-item">
                        <div class="option-icon icon-primary"><i class="mdi mdi-cash-multiple"></i></div>
                        <div class="option-content">
                            <h5>Métodos de Pago</h5>
                            <span>Apertura de nuevas formas de pago.</span>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- RESTAURANT SETTINGS -->
        <div class="col-lg-4">
            <div class="card card-modern animate-in" style="animation-delay: 0.3s;">
                <div class="card-heading text-success"><i class="mdi mdi-silverware-fork-knife mr-2"></i>Restaurante</div>
                <div class="option-list">
                    <a href="ajuste/caja" class="option-item">
                        <div class="option-icon icon-success"><i class="mdi mdi-cash"></i></div>
                        <div class="option-content">
                            <h5>Cajas</h5>
                            <span>Puntos de venta y arqueo.</span>
                        </div>
                    </a>
                    <a href="ajuste/areaprod" class="option-item">
                        <div class="option-icon icon-success"><i class="mdi mdi-store"></i></div>
                        <div class="option-content">
                            <h5>Áreas de Producción</h5>
                            <span>Cocina, barra, despacho.</span>
                        </div>
                    </a>
                    <a href="ajuste/salon-mesa" class="option-item">
                        <div class="option-icon icon-success"><i class="mdi mdi-view-grid"></i></div>
                        <div class="option-content">
                            <h5>Salones y Mesas</h5>
                            <span>Distribución del local.</span>
                        </div>
                    </a>
                     <a href="ajuste/producto" class="option-item">
                        <div class="option-icon icon-success"><i class="mdi mdi-food"></i></div>
                        <div class="option-content">
                            <h5>Productos</h5>
                            <span>Carta, precios e inventario.</span>
                        </div>
                    </a>
                </div>
            </div>
        </div>        
    </div>
</div>

<div class="modal inmodal" id="modal-plataforma" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content animated bounceInTop modal-content-modern">
        <form id="form-plataforma" method="post" enctype="multipart/form-data">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title"><i class="ti-shield mr-2"></i>Configuración Plataforma</h4>
                <button type="button" class="close text-white" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <!-- Basic Config Section -->
                <div class="row floating-labels mb-4">
                    <div class="col-12 mb-3">
                        <h6 class="text-primary font-weight-bold text-uppercase border-bottom pb-2 mb-3">Límites y Facturación</h6>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group m-b-30 form-group-modern">
                            <input type="text" class="form-control font-14 text-center" name="created_at" id="created_at" value="" autocomplete="off"/>
                            <span class="bar"></span>
                            <label><i class="ti-calendar mr-1"></i>Fecha de facturación</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group f m-b-30 letNumMayMin form-group-modern">
                            <input type="text" class="form-control input-mayus cbu text-center" name="limit_documents" id="limit_documents" autocomplete="off">
                            <span class="bar"></span>
                            <label for="limit_documents"><i class="ti-file mr-1"></i>Límite de CPE</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group f m-b-30 letNumMayMin form-group-modern">
                            <input type="text" class="form-control input-mayus cbu text-center" name="limit_users" id="limit_users" autocomplete="off">
                            <span class="bar"></span>
                            <label for="limit_users"><i class="ti-user mr-1"></i>Límite de usuarios</label>
                        </div>
                    </div>
                </div>

                <!-- Security Switches (Vertical List) -->
                <div class="row">
                    <div class="col-12 mb-2">
                        <h6 class="text-primary font-weight-bold text-uppercase border-bottom pb-2 mb-3">Seguridad y Bloqueos</h6>
                    </div>

                    <div class="col-12">
                        <ul class="list-group list-group-flush w-100">
                            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-3">
                                <div>
                                    <h6 class="font-weight-bold mb-0" style="color: #455a64;">Bloquear comprobantes</h6>
                                    <div class="text-muted font-12">Impide crear más comprobantes</div>
                                </div>
                                <div class="switch">
                                    <label><input type="checkbox" id="locked_documents"><span class="lever switch-col-light-green"></span></label>
                                    <input type="hidden" name="locked_documents" id="locked_documents_hidden">
                                </div>
                            </li>

                            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-3">
                                <div>
                                    <h6 class="font-weight-bold mb-0" style="color: #455a64;">Bloquear usuarios</h6>
                                    <div class="text-muted font-12">Impide crear nuevos usuarios</div>
                                </div>
                                <div class="switch">
                                    <label><input type="checkbox" id="locked_users"><span class="lever switch-col-light-green"></span></label>
                                    <input type="hidden" name="locked_users" id="locked_users_hidden">
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="col-md-12 div_porcentaje_comision mt-3" style="display: none">
                         <div class="form-group form-group-modern">
                            <input type="text" class="form-control text-center" name="porcentaje_comision" id="porcentaje_comision" autocomplete="off">
                            <span class="bar"></span>
                            <label for="porcentaje_comision">% Comisión</label>
                        </div>
                    </div>

                    <!-- WhatsApp Section -->
                    <div class="col-12 mt-4 mb-2">
                         <h6 class="text-success font-weight-bold text-uppercase border-bottom pb-2 mb-3"><i class="fab fa-whatsapp mr-1"></i>Integración WhatsApp</h6>
                    </div>
                    
                    <div class="col-12">
                         <ul class="list-group list-group-flush w-100">
                            <li class="list-group-item d-flex justify-content-between align-items-center px-0 py-3">
                                <div>
                                    <h6 class="font-weight-bold mb-0" style="color: #455a64;">API Whatsapp</h6>
                                    <div class="text-muted font-12">Envío directo de mensajes sin WhatsApp Web</div>
                                </div>
                                <div class="switch">
                                    <label><input type="checkbox" id="api_wsp"><span class="lever switch-col-light-green"></span></label>
                                    <input type="hidden" name="api_wsp" id="api_wsp_hidden">
                                </div>
                            </li>
                        </ul>
                    </div>

                    <div class="col-md-12 div_token_wsp mt-4" style="display: none">
                        <div class="form-group form-group-modern">
                            <input type="text" class="form-control text-center text-monospace" name="wsp_token" id="wsp_token" autocomplete="off" style="font-size: 0.9rem; background: #f1f3f5;">
                            <span class="bar"></span>
                            <label for="wsp_token">TOKEN DE ACCESO</label>
                        </div>
                    </div>
                    <div class="col-md-12 div_token_wsp mt-3" style="display: none">
                        <div class="form-group form-group-modern">
                            <textarea class="form-control text-center" name="wsp_message" id="wsp_message" rows="4" placeholder="Escribe aquí tu mensaje..."></textarea>
                            <span class="bar"></span>
                            <label for="wsp_message">Mensaje Personalizado</label>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="col-md-12 mt-4">
                        <?php if(Session::get('bloqueo_id') == '0'):   ?>
                            <button type="button" onclick="bloc_desbloc();" class="btn btn-danger btn-block btn-modern"><i class="fas fa-ban mr-2"></i> Bloquear Acceso por Falta de Pago</button>
                        <?php else : ?>
                            <button type="button" onclick="bloc_desbloc();" class="btn btn-success btn-block btn-modern btn-modern-success"><i class="fas fa-check mr-2"></i> Desbloquear Plataforma</button>
                        <?php endif; ?>   
                    </div>

                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-modern btn-modern-success">Guardar Configuración</button>
            </div>
        </form>
        </div>
    </div>
</div>








<script type="text/javascript">
    $('#navbar-c').addClass("white-bg");
    $('#config').addClass("active");

    var bloc_desbloc = function(){

        var html_confirm = '<div><?php print (Session::get('bloqueo_id') == '0')? 'Se procederá a desbloquear la plataforma' : 'Se procederá a bloquear la plataforma'; ?></div><br>\
            <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
        Swal.fire({
            title: 'Necesitamos de tu Confirmación',
            html: html_confirm,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#34d16e',
            confirmButtonText: 'Si, Adelante!',
            cancelButtonText: "No!",
            showLoaderOnConfirm: true,
            preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'ajuste/bloqueo',
                    type: 'POST',
                    data: {
                        // $ver = (Session::get('rol') == 1) ? '' :  header('location: ' . URL . 'err/danger'); 

                        tipo_bloqueo  : <?php print (Session::get('bloqueo_id') == '0')? '1' : '0';      ?>,
                        },
                    dataType: 'json'
                })
                .done(function(response){
                    if(response == 1){
                    Swal.fire({
                        title: 'Proceso Terminado',
                        text: 'Datos eliminados correctamente',
                        icon: 'success',
                        showConfirmButton: false,
                    });
                    location.reload();
                    }else{
                        Swal.fire({
                            title: 'Proceso No Culminado',
                            text: 'no se pueden eliminar',
                            icon: 'error',
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar"
                        });
                    }
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                });
            });
            },
            allowOutsideClick: false              
        });
    }



</script>