<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y h:i A");
?>

<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === CARD APERTURA/CIERRE === */
.card-apercie {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    /* overflow: hidden; */
}

.status-section {
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 300px;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
}

.status-icon-locked {
    font-size: 5rem;
    color: #ced4da;
    margin-bottom: 1rem;
}

.status-icon-open {
    font-size: 5rem;
    color: var(--success-color);
    margin-bottom: 1rem;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.05); }
}

.status-badge {
    display: inline-block;
    padding: 0.75rem 2rem;
    border-radius: 25px;
    font-weight: 600;
    font-size: 1rem;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-bottom: 1rem;
}

.status-badge.closed {
    background: linear-gradient(135deg, var(--danger-color) 0%, #c0392b 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(231, 76, 60, 0.3);
}

.status-badge.open {
    background: linear-gradient(135deg, var(--success-color) 0%, #0ea332 100%);
    color: white;
    box-shadow: 0 4px 15px rgba(27, 201, 67, 0.3);
}

.status-text {
    color: #6c757d;
    font-size: 0.9375rem;
}

/* === FORM SECTION === */
.form-section {
    background: white;
    padding: 2rem;
    border-radius: var(--border-radius);
}

/* === ESTILOS PARA SELECT Y INPUTS === */
.form-control, 
.selectpicker,
.bootstrap-select .btn {
    border: 1.5px solid #ced4da !important;
    border-radius: 8px !important;
    transition: var(--transition);
}

.form-control:focus,
.bootstrap-select.open .btn {
    border-color: var(--primary-color) !important;
    box-shadow: 0 0 0 0.2rem rgba(86, 100, 210, 0.15) !important;
}

.bootstrap-select .dropdown-toggle {
    background: white !important;
    border: 1.5px solid #ced4da !important;
}

.bootstrap-select .dropdown-toggle:hover {
    border-color: var(--primary-color) !important;
}

/* === INPUT GROUP MONTO === */
.input-group-monto {
    border: 1.5px solid #ced4da;
    border-radius: 8px;
    overflow: hidden;
}

.input-group-monto .input-group-text {
    background: var(--light-bg);
    border: none;
    font-weight: 500;
}

.input-group-monto .form-control {
    border: none !important;
    font-size: 1.5rem;
    font-weight: 600;
    text-align: center;
}

/* === BOTONES === */
.btn-open-cash {
    background: linear-gradient(135deg, var(--success-color) 0%, #0ea332 100%);
    border: none;
    color: white;
    font-weight: 600;
    padding: 1rem;
    border-radius: 8px;
    transition: var(--transition);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-open-cash:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(27, 201, 67, 0.4);
    color: white;
}

.btn-close-cash {
    background: linear-gradient(135deg, var(--danger-color) 0%, #c0392b 100%);
    border: none;
    color: white;
    font-weight: 600;
    padding: 1rem;
    border-radius: 8px;
    transition: var(--transition);
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.btn-close-cash:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(231, 76, 60, 0.4);
    color: white;
}

/* === TABLA DE LISTADO === */
.card-list {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
}

.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}

/* === RESPONSIVE === */
@media (max-width: 992px) {
    .card-apercie .row > div {
        border-right: none !important;
        border-bottom: 2px solid #e9ecef;
    }
    
    .card-apercie .row > div:last-child {
        border-bottom: none;
    }
}

@media (max-width: 768px) {
    .page-titles-modern {
        padding: 1.5rem;
    }
    
    .page-titles-modern h4 {
        font-size: 1.5rem;
    }
    
    .status-section {
        min-height: 250px;
    }
    
    .status-icon-locked,
    .status-icon-open {
        font-size: 4rem;
    }
    
    .form-section {
        padding: 1.5rem;
    }
    
    .input-group-monto .form-control {
        font-size: 1.25rem;
    }
    
    .table-modern thead th,
    .table-modern tbody td {
        padding: 0.75rem 0.5rem;
        font-size: 0.875rem;
    }
}

@media (max-width: 576px) {
    .page-titles-modern {
        padding: 1rem;
        margin-bottom: 1rem;
    }
    
    .page-titles-modern h4 {
        font-size: 1.25rem;
    }
    
    .breadcrumb-modern {
        font-size: 0.75rem;
        padding: 0.375rem 0.75rem;
    }
    
    .status-section {
        min-height: 200px;
    }
    
    .status-icon-locked,
    .status-icon-open {
        font-size: 3rem;
    }
    
    .status-badge {
        padding: 0.5rem 1.5rem;
        font-size: 0.875rem;
    }
    
    .form-section {
        padding: 1rem;
    }
}
</style>

<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<input type="hidden" id="codRol" value="<?php echo Session::get('rol'); ?>"/>
<input type="hidden" id="stock_pollo" value=""/>
<input type="hidden" id="fechaC" value="<?php echo $fecha; ?>"/>

<!-- HEADER MODERNO -->
<div class="page-titles-modern animate-in">
    <h4><i class="mdi mdi-cash-register mr-2"></i>Apertura y Cierre de Caja</h4>
    <div class="breadcrumb-modern">
        <span class="breadcrumb-item"><a href="<?php echo URL; ?>caja/apercie"><i class="fa fa-home mr-1"></i>Inicio</a></span>
        <span class="breadcrumb-item">/</span>
        <span class="breadcrumb-item active">Apertura y cierre</span>
    </div>
</div>

<div class="row">
    <div class="col-lg-7 col-md-12 mb-3">
        <div class="card card-apercie animate-in">
            <div class="row" style="margin: 0;">
                <!-- SECCIÓN DE ESTADO -->
                <div class="col-lg-6 p-0">
                    <div class="status-section">
                        <div class="text-center display-apertura" style="display: none;">
                            <i class="fa fa-lock status-icon-locked"></i>
                            <div>
                                <span class="status-badge closed">CERRADO</span>
                                <p class="status-text">Ingrese los datos<br>para abrir una caja</p>
                            </div>
                        </div>
                        <div class="text-center display-cierre" style="display: none;">
                            <i class="fa fa-unlock status-icon-open"></i>
                            <div>
                                <span class="status-badge open">ABIERTO</span>
                                <p class="status-text fecha-apertura"></p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- SECCIÓN DE FORMULARIO -->
                <div class="col-lg-6 p-0">
                    <!-- FORMULARIO APERTURA -->
                    <form id="form-apertura" method="post" class="display-apertura form-section" style="display: none;" enctype="multipart/form-data">
                        <div class="form-group-modern m-b-30">
                            <select class="selectpicker form-control" name="id_caja" id="id_caja" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" autocomplete="off" required="required">
                                <?php foreach($this->Caja as $key => $value): ?>
                                    <option value="<?php echo $value['id_caja']; ?>"><?php echo $value['descripcion']; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <span class="bar"></span>
                            <label for="id_caja"><i class="ti-package mr-1"></i>Caja</label>
                        </div>
                        
                        <div class="form-group-modern m-b-30">
                            <select class="selectpicker form-control" name="id_turno" id="id_turno" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" autocomplete="off" required="required">
                                <?php foreach($this->Turno as $key => $value): ?>
                                    <option value="<?php echo $value['id_turno']; ?>"><?php echo $value['descripcion']; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <span class="bar"></span>
                            <label for="id_turno"><i class="ti-time mr-1"></i>Turno</label>
                        </div>
                        
                        <div class="form-group-modern m-b-20">
                            <label class="font-13 text-dark font-weight-bold mb-2">
                                <i class="fa fa-dollar mr-1"></i>MONTO DE APERTURA
                            </label>
                            <div class="input-group-monto">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <small class="d-block">EFE</small>
                                        <strong><?php echo Session::get('moneda'); ?></strong>
                                    </span>
                                </div>
                                <input type="text" name="onlyNum" class="form-control" name="monto_aper" id="monto_aper" value="0" autocomplete="off" required>
                                <div class="input-group-append">
                                    <span class="input-group-text"><?php echo Session::get('monAcr'); ?></span>
                                </div>
                            </div>                           
                        </div>
                        
                        <button type="submit" class="btn btn-open-cash btn-block btn-aceptar-apertura mt-4">
                            <i class="fa fa-unlock mr-2"></i>ABRIR CAJA
                        </button>
                    </form>
                    
                    <!-- FORMULARIO CIERRE -->
                    <form id="form-cierre" method="post" class="display-cierre form-section" style="display: none;" enctype="multipart/form-data">
                        <input type="hidden" name="id_apc" id="id_apc">
                        <input type="hidden" name="monto_sistema" id="monto_sistema">
                        <input type="hidden" name="count_ocupadas" id="count_ocupadas">
                        <input type="hidden" name="count_pedidos" id="count_pedidos">
                        <input type="hidden" name="count_mostrador" id="count_mostrador">
                        
                        <div class="form-group-modern m-b-20">
                            <label class="font-13 text-dark font-weight-bold mb-2">
                                <i class="fa fa-dollar mr-1"></i>MONTO DE CIERRE
                            </label>
                            <div class="input-group-monto">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">
                                        <small class="d-block">EFE</small>
                                        <strong><?php echo Session::get('moneda'); ?></strong>
                                    </span>
                                </div>
                                <input type="text" name="onlyNum" class="form-control" name="monto_cierre" id="monto_cierre" value="0" autocomplete="off" required>
                                <div class="input-group-append">
                                    <span class="input-group-text"><?php echo Session::get('monAcr'); ?></span>
                                </div>
                            </div>
                            <small class="text-muted font-italic mt-2 d-block">
                                <i class="fa fa-info-circle mr-1"></i>Considerar solo dinero en efectivo
                            </small>
                        </div>
                        
                        <button type="submit" class="btn btn-close-cash btn-block btn-aceptar-cierre mt-4">
                            <i class="fa fa-lock mr-2"></i>CERRAR CAJA
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- LISTADO DE CAJAS -->
    <div class="col-lg-5 col-md-12">
        <div class="card card-list animate-in">
            <div class="card-body p-0">
               <h5 class="m-3 font-weight-bold">
                   <i class="fas fa-list-alt mr-2 text-primary"></i>
                   Listado de cajas aperturadas
               </h5>
               <div class="table-responsive b-t m-b-0">
                    <table class="table table-modern table-hover table-condensed">
                        <thead>
                            <tr>
                                <th>Caja</th>
                                <th>Usuario</th>
                                <th class="text-right">Monto apertura</th>
                                <th>Opción</th>
                            </tr>
                        </thead>
                        <tbody id="lista_caja"></tbody>
                    </table>
                </div>             
            </div>
        </div>
    </div>    
</div>

<script>
$(function() {
    var id_caja_ = $("#id_caja option:first-child").val();
    $('#id_caja').selectpicker('val', ''+id_caja_+'');
    var id_turno_ = $("#id_turno option:first-child").val();
    $('#id_turno').selectpicker('val', ''+id_turno_+'');
});

document.addEventListener('DOMContentLoaded', function() {
    const animateElements = document.querySelectorAll('.animate-in');
    animateElements.forEach((el, index) => {
        el.style.animationDelay = `${index * 0.1}s`;
    });
});
</script>
