<?php Session::init(); if (Session::get('rol') == 1 OR Session::get('rol') == 2 OR Session::get('rol') == 3) { ?>
<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y H:i", strtotime('today 00:00:00'));

$fechaa = date("d-m-Y H:i", strtotime('+5 minutes'));
 
$codigo_anular_venta = Session::get('cod_seg');
?>

<!-- Custom Styles for Monitor -->
<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.75rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.5rem 1rem;
    border-radius: 20px;
    display: inline-block;
}

.breadcrumb-modern .breadcrumb-item {
    color: rgba(255, 255, 255, 0.9);
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

.breadcrumb-modern a {
    color: white;
    text-decoration: none;
}

/* === TABS MODERNOS === */
.nav-tabs-modern {
    border-bottom: 2px solid #e9ecef;
    margin-bottom: 0;
}

.nav-tabs-modern .nav-link {
    border: none;
    color: #6c757d;
    font-weight: 500;
    padding: 1rem 1.5rem;
    position: relative;
    transition: var(--transition);
}

.nav-tabs-modern .nav-link:hover {
    color: var(--primary-color);
    background: transparent;
}

.nav-tabs-modern .nav-link.active {
    color: var(--primary-color);
    background: transparent;
    border-bottom: 3px solid var(--primary-color);
}

/* === TARJETAS DE ESTADÍSTICAS === */
.stats-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    border-left: 4px solid;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    right: 0;
    width: 100px;
    height: 100px;
    background: currentColor;
    opacity: 0.05;
    border-radius: 50%;
    transform: translate(30%, -30%);
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: var(--card-shadow-hover);
}

.stat-card.stat-primary { border-left-color: var(--primary-color); color: var(--primary-color); }
.stat-card.stat-success { border-left-color: var(--success-color); color: var(--success-color); }
.stat-card.stat-warning { border-left-color: var(--warning-color); color: var(--warning-color); }
.stat-card.stat-danger { border-left-color: var(--danger-color); color: var(--danger-color); }
.stat-card.stat-info { border-left-color: var(--info-color); color: var(--info-color); }
.stat-card.stat-dark { border-left-color: var(--dark-color); color: var(--dark-color); }

.stat-icon {
    font-size: 2.5rem;
    opacity: 0.2;
    position: absolute;
    right: 1rem;
    top: 50%;
    transform: translateY(-50%);
}

.stat-value {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0.25rem;
    position: relative;
    z-index: 1;
}

.stat-label {
    font-size: 0.875rem;
    font-weight: 500;
    color: #6c757d;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    position: relative;
    z-index: 1;
}

/* === FILTROS MEJORADOS === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 1.5rem;
}

.filter-section {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 1rem;
}

.filter-row-dates {
    grid-column: span 2;
}

.form-group-modern {
    position: relative;
}

.form-group-modern label {
    font-size: 0.875rem;
    font-weight: 500;
    color: #495057;
    margin-bottom: 0.5rem;
    display: block;
}

.input-group-dates {
    display: flex;
    gap: 0.5rem;
    align-items: center;
}

.input-group-dates .form-control {
    flex: 1;
}

.input-group-dates .input-group-text {
    background: var(--light-bg);
    border: 1px solid #ced4da;
    color: #6c757d;
    font-weight: 500;
    padding: 0.5rem 1rem;
    border-radius: 8px;
}

/* === ESTILOS PARA SELECT Y INPUTS === */
.form-control, 
.selectpicker,
.bootstrap-select .btn {
    border: 1.5px solid #ced4da !important;
    border-radius: 8px !important;
    transition: var(--transition);
}

.form-control:focus,
.bootstrap-select.open .btn {
    border-color: var(--primary-color) !important;
    box-shadow: 0 0 0 0.2rem rgba(86, 100, 210, 0.15) !important;
}

.bootstrap-select .dropdown-toggle {
    background: white !important;
    border: 1.5px solid #ced4da !important;
}

.bootstrap-select .dropdown-toggle:hover {
    border-color: var(--primary-color) !important;
}

/* === TABLA RESPONSIVE === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
}

.table-responsive-modern {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.table-modern {
    margin-bottom: 0;
}

.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

.table-modern thead th {
    border: none;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    padding: 1rem;
    white-space: nowrap;
}

.table-modern tbody tr {
    transition: var(--transition);
    border-bottom: 1px solid #f1f3f5;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.01);
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
}

/* === BADGES Y ETIQUETAS === */
.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.badge-efectivo {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}

/* === BOTONES MEJORADOS === */
.btn-action {
    border: none;
    background: transparent;
    padding: 0.5rem;
    margin: 0 0.25rem;
    border-radius: 8px;
    transition: var(--transition);
    color: #6c757d;
}

.btn-action:hover {
    background: var(--light-bg);
    color: var(--primary-color);
    transform: scale(1.1);
}

.btn-action i {
    font-size: 1.125rem;
}

/* === MODALES MODERNOS === */
.modal-content-modern {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: 0 10px 40px rgba(0,0,0,0.2);
}

.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    color: white;
    border: none;
    border-radius: var(--border-radius) var(--border-radius) 0 0;
    padding: 1.5rem;
}

.modal-header-modern .modal-title {
    font-weight: 600;
    color: white;
}

.modal-body-modern {
    padding: 2rem;
}

.modal-footer-modern {
    border: none;
    padding: 1.5rem;
    background: var(--light-bg);
}

/* === LOADING STATE === */
.loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.9);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    border-radius: var(--border-radius);
}

.spinner {
    width: 50px;
    height: 50px;
    border: 4px solid #f3f3f3;
    border-top: 4px solid var(--primary-color);
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* === RESPONSIVE === */
@media (max-width: 1200px) {
    .stats-container {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 768px) {
    .page-titles-modern {
        padding: 1.5rem;
    }
    
    .page-titles-modern h4 {
        font-size: 1.5rem;
    }
    
    .stats-container {
        grid-template-columns: repeat(2, 1fr);
        gap: 1rem;
    }
    
    .stat-card {
        padding: 1rem;
    }
    
    .stat-value {
        font-size: 1.5rem;
    }
    
    .stat-icon {
        font-size: 2rem;
    }
    
    .filter-section {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .filter-row-dates {
        grid-column: span 1;
    }
    
    .input-group-dates {
        flex-direction: column;
        gap: 0.75rem;
    }
    
    .input-group-dates .input-group-text {
        padding: 0.375rem 0.75rem;
        font-size: 0.875rem;
    }
    
    .nav-tabs-modern .nav-link {
        padding: 0.75rem 1rem;
        font-size: 0.875rem;
    }
    
    .table-modern thead th,
    .table-modern tbody td {
        padding: 0.75rem 0.5rem;
        font-size: 0.875rem;
    }
    
    .form-control,
    .bootstrap-select .btn {
        font-size: 0.875rem;
        padding: 0.5rem 0.75rem;
    }
}

@media (max-width: 576px) {
    /* MANTENER 2 COLUMNAS EN MOBILE */
    .stats-container {
        grid-template-columns: repeat(2, 1fr);
        gap: 0.75rem;
    }
    
    .stat-card {
        padding: 0.875rem;
    }
    
    .stat-value {
        font-size: 1.25rem;
    }
    
    .stat-label {
        font-size: 0.65rem;
        line-height: 1.2;
    }
    
    .stat-icon {
        font-size: 1.75rem;
        right: 0.5rem;
    }
    
    .filters-card {
        padding: 1rem;
    }
    
    .page-titles-modern {
        padding: 1rem;
        margin-bottom: 1rem;
    }
    
    .page-titles-modern h4 {
        font-size: 1.25rem;
    }
    
    .breadcrumb-modern {
        font-size: 0.75rem;
        padding: 0.375rem 0.75rem;
    }
    
    .nav-tabs-modern .nav-link {
        padding: 0.625rem 0.75rem;
        font-size: 0.8125rem;
    }
    
    .table-card {
        margin-top: 1rem;
    }
}

/* === EXTRA PEQUEÑO (< 400px) === */
@media (max-width: 400px) {
    .stat-card {
        padding: 0.75rem 0.625rem;
    }
    
    .stat-value {
        font-size: 1.125rem;
    }
    
    .stat-label {
        font-size: 0.6rem;
    }
    
    .stat-icon {
        font-size: 1.5rem;
    }
    
    .page-titles-modern h4 {
        font-size: 1.125rem;
    }
    
    .form-group-modern label {
        font-size: 0.8125rem;
    }
}

/* === ANIMACIONES === */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.animate-in {
    animation: fadeInUp 0.5s ease;
}

/* === SCROLLBAR PERSONALIZADO === */
.table-responsive-modern::-webkit-scrollbar {
    height: 8px;
}

.table-responsive-modern::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 10px;
}

.table-responsive-modern::-webkit-scrollbar-thumb {
    background: var(--primary-color);
    border-radius: 10px;
}

.table-responsive-modern::-webkit-scrollbar-thumb:hover {
    background: #667eea;
}
</style>

<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<input type="hidden" id="codRol" value="<?php echo Session::get('rol'); ?>"/>
<input type="hidden" id="tribAcr" value="<?php echo Session::get('tribAcr'); ?>"/>
<input type="hidden" id="diAcr" value="<?php echo Session::get('diAcr'); ?>"/>
<input type="hidden" id="id_apc" value=""/>
<input type="hidden" id="codigo_anular_venta" value="<?php echo $codigo_anular_venta; ?>"/>

<!-- HEADER MODERNO -->
<div class="page-titles-modern animate-in">
    <h4><i class="mdi mdi-cash-register mr-2"></i>Monitor de Ventas</h4>
    <div class="breadcrumb-modern">
        <span class="breadcrumb-item"><a href="<?php echo URL; ?>caja/monitor" class="link"><i class="fa fa-home mr-1"></i>Inicio</a></span>
        <span class="breadcrumb-item">/</span>
        <span class="breadcrumb-item active">Monitor de ventas</span>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card" style="border: none; border-radius: var(--border-radius); box-shadow: var(--card-shadow);">
            <div class="card-body p-0">
                <!-- TABS MODERNOS -->
                <ul class="nav nav-tabs nav-tabs-modern" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link list-mesas" data-toggle="tab" href="#tab1" role="tab">
                            <i class="fa fa-cutlery mr-2"></i>
                            <span class="hidden-sm-up">Mesas</span>
                            <span class="hidden-xs-down">Mesas por cobrar</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link list-ventas active" data-toggle="tab" href="#tab2" role="tab">
                            <i class="fa fa-list-alt mr-2"></i>
                            <span class="hidden-sm-up">Ventas</span>
                            <span class="hidden-xs-down">Lista de ventas</span>
                        </a>
                    </li>
                </ul>

                <!-- TAB CONTENT -->
                <div class="tab-content">
                    <!-- TAB 1: MESAS POR COBRAR -->
                    <div class="tab-pane p-3" id="tab1" role="tabpanel">
                        <div class="stats-container animate-in" style="grid-template-columns: repeat(2, 1fr);">
                            <div class="stat-card stat-warning">
                                <i class="fa fa-clipboard stat-icon"></i>
                                <div class="stat-value mesas-operaciones">0</div>
                                <div class="stat-label">Mesas por cobrar</div>
                            </div>
                            <div class="stat-card stat-success">
                                <i class="fa fa-dollar stat-icon"></i>
                                <div class="stat-value mesas-total">S/ 0.00</div>
                                <div class="stat-label">Monto pendiente</div>
                            </div>
                        </div>
                        
                        <div class="table-card animate-in">
                            <div class="table-responsive-modern">
                                <table id="table-mesas" class="table table-modern" width="100%">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Pedido</th>
                                            <th class="text-right">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-st"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- TAB 2: LISTA DE VENTAS -->
                    <div class="tab-pane p-3 active" id="tab2" role="tabpanel">
                        <!-- FILTROS -->
                        <div class="filters-card animate-in">
                            <div class="filter-section">
                                <div class="filter-row-dates">
                                    <div class="form-group-modern">
                                        <label><i class="fa fa-calendar mr-1"></i>Rango de fechas</label>
                                        <div class="input-group-dates">
                                            <input type="text" class="form-control" name="start" id="start" value="<?php echo $fecha; ?>" autocomplete="off" style="border-radius: 8px;"/>
                                            <span class="input-group-text">al</span>
                                            <input type="text" class="form-control" name="end" id="end" value="<?php echo $fechaa; ?>" autocomplete="off" style="border-radius: 8px;"/>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group-modern">
                                    <label><i class="ti-home mr-1"></i>Canal venta</label>
                                    <select class="selectpicker form-control" name="tipo_ped" id="tipo_ped" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                        <option value="%" active>Mostrar todo</option>
                                        <optgroup>
                                            <?php foreach($this->TipoPedido as $key => $value): ?>
                                                <option value="<?php echo $value['id_tipo_pedido']; ?>"><?php echo $value['descripcion']; ?></option>
                                            <?php endforeach; ?>
                                        </optgroup>
                                    </select>
                                </div>
                                
                                <div class="form-group-modern">
                                    <label><i class="fa fa-file-text-o mr-1"></i>Tipo comprobante</label>
                                    <select class="selectpicker form-control" name="tipo_doc" id="tipo_doc" data-style="form-control btn-default" data-live-search="true" autocomplete="off" data-size="5">
                                        <option value="%" active>Mostrar todo</option>
                                        <optgroup>
                                            <?php foreach($this->TipoDocumento as $key => $value): ?>
                                                <option value="<?php echo $value['id_tipo_doc']; ?>"><?php echo $value['descripcion']; ?></option>
                                            <?php endforeach; ?>
                                        </optgroup>
                                    </select>
                                </div>
                                
                                <div class="form-group-modern">
                                    <label><i class="fa fa-search mr-1"></i>Búsqueda</label>
                                    <input type="text" class="form-control global_filter" id="global_filter" autocomplete="off" placeholder="Buscar..." style="border-radius: 8px;">
                                </div>
                            </div>
                        </div>

                        <!-- ESTADÍSTICAS -->
                        <div class="stats-container animate-in">
                            <div class="stat-card stat-primary">
                                <i class="fa fa-shopping-cart stat-icon"></i>
                                <div class="stat-value ventas-operaciones">0</div>
                                <div class="stat-label">Operaciones</div>
                            </div>
                            
                            <div class="stat-card stat-info">
                                <i class="fa fa-motorcycle stat-icon"></i>
                                <div class="stat-value delivery-ventas">S/ 0.00</div>
                                <div class="stat-label">Comisión Delivery</div>
                            </div>
                            
                            <div class="stat-card stat-warning">
                                <i class="fa fa-credit-card stat-icon"></i>
                                <div class="stat-value comisiones-ventas">S/ 0.00</div>
                                <div class="stat-label">Comisión Tarjeta</div>
                            </div>
                            
                            <div class="stat-card stat-danger">
                                <i class="fa fa-ban stat-icon"></i>
                                <div class="stat-value ventas-total-anulados">S/ 0.00</div>
                                <div class="stat-label">Total Anulados</div>
                            </div>
                            
                            <div class="stat-card stat-success">
                                <i class="fa fa-dollar stat-icon"></i>
                                <div class="stat-value ventas-total">S/ 0.00</div>
                                <div class="stat-label">Total</div>
                            </div>
                            
                            <div class="stat-card stat-dark">
                                <i class="fa fa-calculator stat-icon"></i>
                                <div class="stat-value ventas-total-comisiones">S/ 0.00</div>
                                <div class="stat-label">Total + Comisiones</div>
                            </div>
                        </div>

                        <!-- TABLA DE VENTAS -->
                        <div class="table-card animate-in">
                            <div class="table-responsive-modern">
                                <table id="table-ventas" class="table table-modern" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="10px">ID</th>
                                            <th>Fecha</th>
                                            <th>Documento</th>
                                            <th>Cliente</th>
                                            <th>Canal venta</th>
                                            <th>Tipo pago</th>
                                            <th>Nota venta</th>
                                            <th class="text-right">Delivery</th>
                                            <th class="text-right">Comisiones</th>
                                            <th class="text-right">Sub Total</th>
                                            <th class="text-right">Descuento</th>
                                            <th class="text-right">Total</th>
                                            <th class="text-right">Opciones</th>
                                        </tr>
                                    </thead>
                                    <tbody class="tb-st"></tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- MODAL EDITAR PAGO -->
<div class="modal inmodal" id="modal-editar-pago" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content modal-content-modern">
        <form id="form-editar-pago" method="post" enctype="multipart/form-data">
            <input type="hidden" name="id_venta" id="id_venta" class="id_venta"/>
            <input type="hidden" name="id_venta_tipopago" id="id_venta_tipopago"/>
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title"><i class="fa fa-edit mr-2"></i>Editar tipo de pago</h4>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="form-group-modern">
                    <label for="id_tipo_pago_v">Tipo pago</label>
                    <select class="selectpicker form-control" name="id_tipo_pago_v" id="id_tipo_pago_v" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true">
                        <?php foreach($this->TipoPago as $key => $value): ?>
                            <option label="<?php echo $value['id_pago']; ?>" value="<?php echo $value['id_tipo_pago']; ?>"><?php echo $value['descripcion']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fa fa-times mr-1"></i>Cancelar
                </button>
                <button type="submit" class="btn btn-success">
                    <i class="fa fa-check mr-1"></i>Aceptar
                </button>
            </div>
        </form>
        </div>
    </div>
</div>

<!-- MODAL EDITAR DOCUMENTO -->
<div class="modal inmodal" id="modal-editar-documento" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content modal-content-modern">
        <form id="form-editar-documento" class="form-editar-documento" method="post" enctype="multipart/form-data">
            <input type="hidden" name="id_venta" id="id_venta" class="id_venta" />
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title"><i class="fa fa-file-text-o mr-2"></i>Editar tipo de documento</h4>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="col-lg-12 m-b-20">
                    <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                        <label class="btn waves-effect waves-light btn-secondary btn-tipo-doc-1 active">
                            <input type="radio" name="tipo_doc" value="1" autocomplete="off">
                            <i class="fas fa-receipt mr-1"></i>BOLETA
                        </label>
                        <label class="btn waves-effect waves-light btn-secondary btn-tipo-doc-2">
                            <input type="radio" name="tipo_doc" value="2" autocomplete="off">
                            <i class="fas fa-file-invoice mr-1"></i>FACTURA
                        </label>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="form-group-modern">
                        <label class="font-13">Fecha para emisión</label>
                        <input type="hidden" name="cliente_id" id="cliente_id" value="1"/>
                        <input type="hidden" name="cliente_tipo" id="cliente_tipo" value="1"/>
                        <input type="hidden" name="nv_original" id="nv_original" value=""/>
                        <input type="hidden" name="nv_fecha" id="nv_fecha" value=""/>
                        <input type="text" name="fecha_nueva" id="fecha_nueva" value="" class="form-control" style="border-radius: 8px;" />
                    </div>
                    <div class="form-group-modern mt-3">
                        <label class="font-13">Buscar cliente</label>
                        <div class="input-group">
                            <div class="opcion-cliente input-group-prepend"></div>                       
                            <input type="text" class="form-control" name="buscar_cliente" id="buscar_cliente" value="PUBLICO EN GENERAL" autocomplete="off" style="border-radius: 8px;">
                            <a class="input-group-append" href="javascript:void(0)" id="btnClienteLimpiar" data-original-title="Limpiar datos" data-toggle="tooltip" data-placement="top">
                                <span class="input-group-text bg-header" style="border-radius: 0 8px 8px 0;">
                                    <small><i class="fas fa-times link-danger"></i></small>
                                </span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-1"></i>Cancelar
                </button>
                <button type="submit" class="btn btn-success" id="btn-submit-editar-documento">
                    <i class="fas fa-check mr-1"></i>Aceptar
                </button>
            </div>
        </form>
        </div>
    </div>
</div>

<!-- MODAL CLIENTE -->
<div class="modal inmodal" id="modal-cliente" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content modal-content-modern">
            <form id="form-cliente" method="post" enctype="multipart/form-data">
            <input type="hidden" name="id_cliente" id="id_cliente">
            <input type="hidden" name="tipo_cliente" id="tipo_cliente">
            <div class="modal-header modal-header-modern justify-content-between">
                <h4 class="modal-title-cliente"><i class="fas fa-user-plus mr-2"></i>Nuevo Cliente</h4>
                <?php if(0 == 1){ ?>
                <div class="ml-auto m-t-10">
                    <input name="tipo_cli" type="radio" value="1" id="td_dni" class="with-gap radio-col-light-green"/>
                    <label for="td_dni" style="color: white;"><?php echo Session::get('diAcr'); ?></label>
                    <input name="tipo_cli" type="radio" value="2" id="td_ruc" class="with-gap radio-col-light-green"/>
                    <label for="td_ruc" style="color: white;"><?php echo Session::get('tribAcr'); ?></label>
                </div>
                <?php } else { ?>
                <div class="ml-auto m-t-10"></div>
                <?php } ?>
            </div>
            <div class="modal-body modal-body-modern p-0 floating-labels">
                <div class="row" style="margin: 0;">
                    <!-- Column -->
                    <div class="col-lg-6 b-r p-4">
                        <div class="p-3 mb-3" style="background: var(--light-bg); border-radius: 8px;">
                            <h6 class="font-medium"><i class="fas fa-user mr-2"></i>Información personal</h6>
                        </div>
                        <div class="block01" style="display: block;">
                            <div class="form-group ent m-b-40">
                                <input type="text" class="form-control dni" name="dni" id="dni" minlength="<?php echo Session::get('diCar'); ?>" maxlength="<?php echo Session::get('diCar'); ?>" value="" autocomplete="off" required="required"/>
                                <span class="bar"></span>
                                <label for="dni" class="c-dni"><?php echo Session::get('diAcr'); ?></label>
                            </div>
                        </div>
                        <div class="block02" style="display: none;">
                            <div class="form-group ent m-b-40">
                                <input type="text" class="form-control ruc" name="ruc" id="ruc" minlength="<?php echo Session::get('tribCar'); ?>" maxlength="<?php echo Session::get('tribCar'); ?>" value="" autocomplete="off" required="required"/>
                                <span class="bar"></span>
                                <label for="ruc" class="c-ruc"><?php echo Session::get('tribAcr'); ?></label>
                            </div>
                        </div>                            
                        <div class="block07" style="display: none;">
                            <div class="form-group letNumMayMin m-b-40">
                                <input type="text" class="form-control ruc input-mayus" name="razon_social" id="razon_social" value="" autocomplete="off" required="required"/>
                                <span class="bar"></span>
                                <label for="razon_social">Razón Social</label>
                            </div>
                        </div>
                        <div class="block03" style="display: block;">
                            <div class="form-group letMayMin m-b-40">
                                <input type="text" class="form-control dni input-mayus" name="nombres" id="nombres" value="" autocomplete="off" required="required"/>
                                <span class="bar"></span>
                                <label for="nombres">Nombre completo</label>
                            </div>
                        </div>
                    </div>
                    <!-- Column -->
                    <div class="col-lg-6 p-4">
                        <div class="p-3 mb-3" style="background: var(--light-bg); border-radius: 8px;">
                            <h6 class="font-medium"><i class="fas fa-address-book mr-2"></i>Contacto</h6>
                        </div>
                        <div class="block05" style="display: block;">
                            <div class="form-group m-b-40">
                                <input type="text" class="form-control dni input-mayus" name="fecha_nac" id="fecha_nac" value="" autocomplete="off" data-mask="99-99-9999"/>
                                <span class="bar"></span>
                                <label for="fecha_nac">Fecha de Nacimiento</label>
                            </div>
                        </div>
                        <div class="form-group ent m-b-40">
                            <input type="text" class="form-control" name="telefono" id="telefono" value="" autocomplete="off"/>
                            <span class="bar"></span>
                            <label for="telefono">Teléfono</label>
                        </div>
                        <div class="block06" style="display: block;">
                            <div class="form-group m-b-40">
                                <input type="text" class="form-control dni" name="correo" id="correo" value="" autocomplete="off"/>
                                <span class="bar"></span>
                                <label for="correo">Correo electrónico</label>
                            </div>
                        </div>
                        <?php if(0 == 1){ ?>
                            <div class="block08" style="display: none;">
                        <?php }else{ ?>
                            <div>
                        <?php } ?>
                            <div class="form-group m-b-40">
                                <input type="text" class="form-control" name="direccion" id="direccion" value="" autocomplete="off" required="required"/>
                                <span class="bar"></span>
                                <label for="direccion">Dirección</label>
                            </div>
                        </div>
                        <div class="form-group m-b-40">
                            <input type="text" class="form-control input-mayus" name="referencia" id="referencia" value="" autocomplete="off"/>
                            <span class="bar"></span>
                            <label for="referencia">Referencia</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-1"></i>Volver
                </button>
                <button type="submit" class="btn btn-success">
                    <i class="fas fa-check mr-1"></i>Aceptar
                </button>
            </div>
            </form>
        </div>
    </div>
</div>

<script>
// Animación de entrada para elementos
document.addEventListener('DOMContentLoaded', function() {
    const animateElements = document.querySelectorAll('.animate-in');
    animateElements.forEach((el, index) => {
        el.style.animationDelay = `${index * 0.1}s`;
    });
});
</script>

<?php } ?>
