<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>

<style>
/* === VARIABLES CSS (Extract from monitor.php) === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    position: relative;
    overflow: hidden;
}

.page-titles-modern::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -10%;
    width: 200px;
    height: 200px;
    background: rgba(255,255,255,0.1);
    border-radius: 50%;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === TARJETAS DE ESTADÍSTICAS === */
.stats-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    transition: var(--transition);
    border-left: 5px solid;
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
}

.stat-card::after {
    content: '';
    position: absolute;
    right: -10px;
    bottom: -10px;
    width: 80px;
    height: 80px;
    border-radius: 50%;
    opacity: 0.1;
    background: currentColor;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: var(--card-shadow-hover);
}

.stat-card.stat-primary { border-left-color: var(--primary-color); color: var(--primary-color); }
.stat-card.stat-success { border-left-color: var(--success-color); color: var(--success-color); }
.stat-card.stat-warning { border-left-color: var(--warning-color); color: var(--warning-color); }
.stat-card.stat-danger { border-left-color: var(--danger-color); color: var(--danger-color); }

.stat-icon {
    font-size: 2.5rem;
    margin-right: 1.5rem;
    opacity: 0.8;
}

.stat-content h2 {
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 0;
    line-height: 1.2;
    color: #333;
}

.stat-content h6 {
    font-size: 0.85rem;
    font-weight: 600;
    color: #888;
    text-transform: uppercase;
    letter-spacing: 1px;
    margin-top: 5px;
}

/* === FILTROS MEJORADOS === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 2rem;
}

.filter-section {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    align-items: end;
}

.form-group-modern {
    margin-bottom: 0;
}

.form-group-modern label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
    margin-bottom: 0.5rem;
    display: block;
}

.form-control, .bootstrap-select .btn {
    border: 1px solid #e0e0e0 !important;
    border-radius: 8px !important;
    padding: 0.6rem 1rem !important;
    font-size: 0.95rem !important;
    height: auto !important;
    transition: var(--transition);
}

.form-control:focus, .bootstrap-select .btn:focus {
    border-color: var(--primary-color) !important;
    box-shadow: 0 0 0 3px rgba(86, 100, 210, 0.1) !important;
}

.input-group-dates {
    display: flex;
    align-items: center;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    overflow: hidden;
}

.input-group-dates .form-control {
    border: none !important;
    border-radius: 0 !important;
    text-align: center;
}

.input-group-dates .input-group-text {
    background: #f1f3f5;
    border: none;
    border-left: 1px solid #e0e0e0;
    border-right: 1px solid #e0e0e0;
    padding: 0 1rem;
    font-size: 0.85rem;
    color: #666;
}

/* === TABLA MODERNA === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
    padding: 0;
}

.table-responsive-modern {
    padding: 0;
}

.table-modern {
    width: 100%;
    margin-bottom: 0;
}

.table-modern thead th {
    background: #f8f9fa;
    color: #495057;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    border-bottom: 2px solid #e9ecef;
    padding: 1rem;
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
    border-bottom: 1px solid #f1f3f5;
    color: #333;
    font-size: 0.9rem;
}

.table-modern tbody tr:hover {
    background-color: #f8f9fa;
}

/* === BOTONES === */
.btn-new-modern {
    background: linear-gradient(135deg, #1bc943 0%, #17a032 100%);
    color: white;
    border: none;
    border-radius: 50px;
    padding: 0.8rem 2rem;
    font-weight: 600;
    box-shadow: 0 4px 15px rgba(27, 201, 67, 0.3);
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    text-decoration: none !important;
}

.btn-new-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(27, 201, 67, 0.4);
    color: white;
}

/* === ANIMACIONES === */
.animate-in {
    animation: fadeInUp 0.6s ease;
}

@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

/* === MODAL MODERN === */
.modal-content-modern {
    border: none;
    border-radius: 15px;
    box-shadow: 0 15px 50px rgba(0,0,0,0.2);
}

.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem;
    border-radius: 15px 15px 0 0;
    color: white;
}

.modal-header-modern .close {
    color: white;
    opacity: 0.8;
}

.modal-body-modern {
    padding: 0;
}

.modal-footer-modern {
    border-top: 1px solid #f1f3f5;
    padding: 1.5rem;
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h4><i class="fas fa-shopping-cart mr-2"></i>Historial de Compras</h4>
            <div class="breadcrumb-modern">
                <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Facturación</span>
                <span class="breadcrumb-item">/</span>
                <span class="breadcrumb-item active">Todas las Compras</span>
            </div>
        </div>
        <div>
             <a href="<?php echo URL; ?>compra/nueva-compra" class="btn-new-modern">
                <i class="fas fa-plus mr-2"></i>Nueva Compra
            </a>
        </div>
    </div>
</div>

<!-- STATS -->
<div class="stats-container animate-in">
    <div class="stat-card stat-warning">
        <div class="stat-icon"><i class="fas fa-file-invoice-dollar"></i></div>
        <div class="stat-content">
            <h2 class="compras-operaciones">0</h2>
            <h6>N° Operaciones</h6>
        </div>
    </div>
    <div class="stat-card stat-success">
        <div class="stat-icon"><i class="fas fa-coins"></i></div>
        <div class="stat-content">
            <h2 class="compras-total">0.00</h2>
            <h6>Total de Compras</h6>
        </div>
    </div>
</div>

<!-- FILTERS -->
<div class="filters-card animate-in">
    <div class="filter-section">
        <div class="form-group-modern">
            <label><i class="fas fa-calendar-alt mr-1"></i>Rango de Fechas</label>
            <div class="input-group-dates">
                <input type="text" class="form-control" name="start" id="start" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off" placeholder="Inicio"/>
                <span class="input-group-text">al</span>
                <input type="text" class="form-control" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off" placeholder="Fin"/>
            </div>
        </div>
        
        <div class="form-group-modern">
            <label><i class="fas fa-truck mr-1"></i>Proveedor</label>
             <select class="selectpicker form-control" name="filtro_proveedor" id="filtro_proveedor" data-style="btn-white" data-live-search="true" autocomplete="off" data-size="5">
                <option value="%" active>Mostrar Todo</option>
                <optgroup label="Proveedores">
                    <?php foreach($this->Proveedor as $key => $value): ?>
                        <option value="<?php echo $value['id_prov']; ?>"><?php echo $value['ruc'].' - '.$value['razon_social']; ?></option>
                    <?php endforeach; ?>
                </optgroup>
            </select>
        </div>

        <div class="form-group-modern">
            <label><i class="fas fa-money-bill mr-1"></i>Tipo Pago</label>
             <select class="selectpicker form-control" name="filtro_tipo" id="filtro_tipo" data-style="btn-white" autocomplete="off">
                <option value="%" active>Mostrar Todo</option>
                <option value="1">CONTADO</option>
                <option value="2">CREDITO</option>
            </select>
        </div>

        <div class="form-group-modern">
            <label><i class="fas fa-file-alt mr-1"></i>Documento</label>
             <select class="selectpicker form-control" name="filtro_documento" id="filtro_documento" data-style="btn-white" autocomplete="off">
                <option value="%" active>Mostrar Todo</option>
                <option value="1">BOLETA</option>
                <option value="2">FACTURA</option>
            </select>
        </div>

        <div class="form-group-modern">
             <label><i class="fas fa-check-circle mr-1"></i>Estado</label>
             <select class="selectpicker form-control" name="filtro_estado" id="filtro_estado" data-style="btn-white" autocomplete="off">
                <option value="%" active>Mostrar Todo</option>
                <option value="a">APROBADO</option>
                <option value="i">ANULADO</option>
            </select>
        </div>
    </div>
</div>

<!-- TABLE -->
<div class="table-card animate-in">
    <div class="table-responsive-modern">
        <table id="table01" class="table table-modern" width="100%">
            <thead>
                <tr>
                    <th style="width:10%;">Fech.Reg.</th>
                    <th style="width:10%;">Fech.Doc.</th>
                    <th style="width:15%;">Documento</th>
                    <th style="width:25%;">Proveedor</th>
                    <th style="width:10%;" class="text-right">Total</th>
                    <th style="width:10%;" class="text-center">Tipo</th>
                    <th style="width:10%;" class="text-center">Estado</th>
                    <th style="width:10%;" class="text-right">Acciones</th>
                </tr>
            </thead>
            <tbody class="tb-st"></tbody>
        </table>
    </div>
</div>

<!-- MODAL DETALLE -->
<div class="modal inmodal" id="modal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title m-0"><i class="fas fa-info-circle mr-2"></i>Detalle de Compra</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body modal-body-modern">
                <div class="table-responsive-modern p-3">
                    <table class="table table-modern table-sm mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th>C&oacute;digo</th>
                                <th>Categor&iacute;a</th>
                                <th>Producto</th>
                                <th>Cantidad</th>
                                <th>P.U.</th>
                                <th class="text-right">Importe</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st" id="table02"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>