<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<input type="hidden" id="igv" value="<?php echo number_format(Session::get('igv'),2); ?>"/>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<input type="hidden" id="url" value="<?php echo URL; ?>"/>

<style>
/* === VARIABLES CSS (Extract from monitor.php) === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === CARDS MODERNAS === */
.card-modern {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    border: none;
    margin-bottom: 2rem;
    overflow: hidden;
}

.card-header-modern {
    padding: 1.2rem 1.5rem;
    border-bottom: 1px solid #f0f0f0;
    background: white;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.card-title-modern {
    font-size: 1.1rem;
    font-weight: 700;
    color: #333;
    margin: 0;
}

.card-body-modern {
    padding: 1.5rem;
}

/* === FORMULARIOS === */
.form-group-modern {
    margin-bottom: 1.2rem;
}

.form-group-modern label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
    margin-bottom: 0.5rem;
    display: block;
}

.form-control-modern {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 0.6rem 1rem;
    font-size: 0.95rem;
    width: 100%;
    transition: var(--transition);
}

.form-control-modern:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(86, 100, 210, 0.1);
    outline: none;
}

/* === Product Search Row === */
.search-row {
    background: #f8f9fa;
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 1rem;
    display: flex;
    flex-wrap: wrap; /* Allow wrapping */
    gap: 1rem;
    align-items: flex-end;
}

.search-item-large { flex: 2; min-width: 250px; }
.search-item-small { flex: 1; min-width: 80px; }
.search-item-btn { flex: 0 0 50px; }

@media (max-width: 768px) {
    .search-row {
        flex-direction: column;
        align-items: stretch;
    }
    .search-item-large, .search-item-small, .search-item-btn {
        width: 100%;
        flex: none;
    }
    .page-titles-modern {
        padding: 1rem;
    }
    .card-body-modern {
        padding: 1rem;
    }
}

/* === TABLE === */
.table-modern {
    width: 100%;
    margin-bottom: 0;
}

.table-modern thead th {
    background: #f1f3f5;
    color: #495057;
    font-weight: 600;
    font-size: 0.8rem;
    padding: 1rem;
    border-bottom: 2px solid #e9ecef;
}

.table-modern tbody td {
    padding: 0.8rem 1rem;
    vertical-align: middle;
    border-bottom: 1px solid #f8f9fa;
}

.table-modern input.form-control {
    border: 1px solid #dee2e6;
    border-radius: 6px;
    padding: 0.4rem;
    font-size: 0.9rem;
    background: white !important;
}

/* === TOTALS SECTION === */
.totals-section {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 1.5rem;
    margin-top: 1rem;
}

.total-row {
    display: flex;
    justify-content: flex-end;
    align-items: center;
    margin-bottom: 0.5rem;
}

.total-label {
    font-size: 0.9rem;
    color: #666;
    margin-right: 1rem;
}

.total-value {
    font-size: 1.1rem;
    font-weight: 600;
    color: #333;
    min-width: 100px;
    text-align: right;
}

.grand-total {
    font-size: 1.5rem;
    color: var(--primary-color);
    border-top: 1px solid #dee2e6;
    padding-top: 0.5rem;
    margin-top: 0.5rem;
}

.animate-in { animation: fadeInUp 0.6s ease; }
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<form id="form-compra" method="post">
<div class="row">
    <!-- LEFT COLUMN: GENERAL DATA & PROVIDER -->
    <div class="col-lg-3 col-md-12 mb-3">
        <!-- GENERAL DATA -->
        <div class="card card-modern animate-in">
            <div class="card-header-modern">
                <h5 class="card-title-modern"><i class="fas fa-file-invoice mr-2 text-primary"></i>Datos Generales</h5>
            </div>
            <div class="card-body-modern">
                <div class="form-group-modern">
                    <label>Tipo Compra</label>
                    <select id="id_tipo_compra" name="id_tipo_compra" class="selectpicker form-control" data-style="btn-light border" title="Seleccionar" required>
                        <option value="1">CONTADO</option>
                        <option value="2">CREDITO</option>
                    </select>
                </div>
                
                <div class="form-group-modern">
                    <label>Documento</label>
                    <select id="id_tipo_doc" name="id_tipo_doc" class="selectpicker form-control" data-style="btn-light border" title="Seleccionar" required>
                        <option value="1">BOLETA</option>
                        <option value="2">FACTURA</option>
                    </select>
                </div>

                <div class="row">
                    <div class="col-6">
                        <div class="form-group-modern">
                            <label>Serie</label>
                            <input type="text" name="serie_doc" id="serie_doc" class="form-control-modern" autocomplete="off" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group-modern">
                            <label>Número</label>
                            <input type="text" name="num_doc" id="num_doc" class="form-control-modern" autocomplete="off" required>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-6">
                        <div class="form-group-modern">
                            <label>Fecha</label>
                            <input type="text" name="fecha_c" id="fecha_c" class="form-control-modern" autocomplete="off" required>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group-modern">
                            <label>Hora</label>
                            <input type="text" name="hora_c" id="hora_c" class="form-control-modern" autocomplete="off" required>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- PROVIDER -->
        <div class="card card-modern animate-in">
             <div class="card-header-modern">
                <h5 class="card-title-modern"><i class="fas fa-truck mr-2 text-success"></i>Proveedor</h5>
                <div>
                     <button type="button" class="btn btn-sm btn-outline-danger" id="btnProvLimpiar" title="Limpiar"><i class="fas fa-eraser"></i></button>
                     <button type="button" class="btn btn-sm btn-success shadow-sm" onclick="nuevoProveedor();" title="Nuevo"><i class="fas fa-plus"></i></button>
                </div>
            </div>
            <div class="card-body-modern">
                <div class="form-group-modern">
                    <input type="hidden" id="id_prov"/>
                    <label>Buscar Proveedor</label>
                    <div class="d-flex align-items-center" style="border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden;">
                        <span class="bg-light text-muted px-3 py-2 border-right"><i class="fas fa-search"></i></span>
                        <input type="text" id="buscar_proveedor" class="form-control border-0 shadow-none h-100" placeholder="RUC o Nombre..." autocomplete="off" style="font-size: 0.95rem;"/>
                    </div>
                </div>
                <div class="form-group-modern">
                    <input type="text" class="form-control-modern bg-light" id="datos_proveedor" placeholder="Proveedor Seleccionado" disabled>
                </div>
            </div>
        </div>
    </div>

    <!-- RIGHT COLUMN: DETAILS -->
    <div class="col-lg-9 col-md-12">
        <div class="card card-modern animate-in">
            <div class="card-header-modern">
                <h5 class="card-title-modern">Detalle de Productos</h5>
                <h6 class="text-muted mb-0 font-weight-normal">Agregue los items de la compra</h6>
            </div>
            
            <div class="card-body-modern">
                <!-- SEARCH BAR -->
                <div class="search-row">
                    <div class="search-item-large">
                        <input id="id_tipo_ins_buscar" type="hidden" value="0" />
                        <input id="id_ins_buscar" type="hidden" value="0" />
                        <label class="font-weight-bold font-12 text-muted">Producto / Insumo</label>
                        <input autocomplete="off" id="buscar_insumo" class="form-control-modern" type="text" placeholder="Buscar por nombre..."/>
                    </div>
                    <div class="search-item-small text-center d-none d-md-block">
                        <label class="font-weight-bold font-12 text-muted">U.M.</label>
                        <div id="label-unidad-medida" class="font-weight-bold mt-2">-</div>
                    </div>
                    <div class="search-item-small">
                        <label class="font-weight-bold font-12 text-muted">Cant.</label>
                        <input type="text" id="cantidad_buscar" class="form-control-modern text-center" autocomplete="off" placeholder="0"/>
                    </div>
                    <div class="search-item-small">
                        <label class="font-weight-bold font-12 text-muted">P.U.</label>
                        <input type="text" id="precio_buscar" class="form-control-modern text-center" autocomplete="off" placeholder="0.00"/>
                    </div>
                    <div class="search-item-btn">
                        <button class="btn btn-warning shadow-sm btn-block" id="btn-agregar-insumo" type="button" style="border-radius: 8px; height: 38px; display: flex; align-items: center; justify-content: center;"><i class="fa fa-plus text-white"></i></button>
                    </div>
                </div>

                <!-- TABLE -->
                <div class="table-responsive">
                    <table class="table table-modern">
                        <thead>
                            <tr>
                                <th width="10%">Cant.</th>
                                <th width="40%">Descripción</th>
                                <th width="10%">U.M.</th>
                                <th width="15%" class="text-center">P. Unit.</th>
                                <th width="15%" class="text-center">Importe</th>
                                <th width="10%" class="text-right">Acción</th>
                            </tr>
                        </thead>
                        <tbody id="table-detalle"></tbody>
                    </table>
                </div>

                <!-- FOOTER / TOTALS -->
                <div class="totals-section">
                    <div class="row">
                        <div class="col-md-5">
                             <div id="mensaje-credito" style="display: none;">
                                <div class="alert alert-warning mb-0 shadow-sm border-0">
                                    <i class="fas fa-exclamation-triangle mr-2"></i>
                                    Click <a class="font-weight-bold link-credito-1" href="javascript:void(0)">AQUÍ</a> para configurar cuotas.
                                </div>
                            </div>
                            
                            <div class="mt-3">
                                <div class="custom-control custom-checkbox mb-2">
                                    <input type="checkbox" class="custom-control-input pcompra" id="pcompra" name="pcompra">
                                    <label class="custom-control-label" for="pcompra">Editar precio de compra (inventario)</label>
                                </div>
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input egreso" id="egreso" name="egreso">
                                    <label class="custom-control-label" for="egreso">Registrar como egreso de caja</label>
                                </div>
                                
                                <div class="monto-egreso mt-2" style="display: none;">
                                    <input type="text" class="form-control-modern" name="monto_egreso" id="monto_egreso" placeholder="Monto a egresar" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-7">
                            <div class="total-row">
                                <span class="total-label">SubTotal</span>
                                <input type="hidden" id="subtotal_global" value="0"/>
                                <span class="total-value"><?php echo Session::get('moneda'); ?> <span class="subtotal_global">0.00</span></span>
                            </div>
                            
                            <div class="total-row">
                                <span class="total-label">Descuento</span>
                                <input type="hidden" id="tipo_compra" value="1"/>
                                <input type="text" id="total_descuento_aumento" class="form-control form-control-sm text-right" value="0.00" style="width: 100px; border-radius: 4px; border: 1px solid #ddd;" autocomplete="off"/>
                            </div>

                            <div class="total-row grand-total">
                                <span class="total-label text-dark font-weight-bold">TOTAL</span>
                                <span class="total-value text-primary"><?php echo Session::get('moneda'); ?> <span class="total_global">0.00</span></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card-footer bg-white border-top-0 text-right p-3">
                <a class="btn btn-light border mr-2" href="<?php echo URL; ?>compra">Cancelar</a>
                <button class="btn btn-success shadow-sm px-4">Guardar Compra</button>
            </div>
        </div>
    </div>
</div>

<!-- MODAL CREDITO (Keep existing structure but style classes) -->
<div class="modal inmodal" id="modal-credito" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title font-weight-bold">Cronograma de Pagos</h4>
            </div>
            <div class="modal-body modal-body-modern p-4">
                <input type="hidden" id="filtro_cuotas"/>
                <div class="row">
                    <div class="col-6">
                        <div class="form-group-modern">
                            <label>Monto Total</label>
                            <input class="form-control-modern bg-light total_credito_" type="text" id="total_credito" value="0.00" readonly>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group-modern">
                            <label>N° Cuotas</label>
                            <input class="form-control-modern" type="text" name="cuotas_credito" id="cuotas_credito" value="">
                        </div>
                    </div>
                </div>
                <div class="table-responsive mt-3 border rounded">
                    <table class="table table-hover table-striped mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th>Total</th>
                                <th class="text-right">Fecha de pago</th>
                            </tr>
                        </thead>
                        <tbody id="table-cuotas" class="display-flex dec"></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success btn-aceptar-cuota">Confirmar Cronograma</button>
            </div>
        </div>
    </div>
</div>
</form>

<!-- MODAL PROVEEDOR (From previous task, already styling match) -->
<div class="modal inmodal" id="modal-proveedor" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <div class="modal-header modal-header-modern">
                <h4 class="modal-title">Nuevo Proveedor</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <form method="post" id="form-proveedor">
            <div class="modal-body modal-body-modern p-4">
                <div class="row">
                    <div class="col-md-6">
                         <div class="form-group-modern">
                            <label><?php echo $_SESSION["tribAcr"]; ?></label>
                            <input type="text" name="ruc" id="ruc" minlength="<?php echo $_SESSION["tribCar"]; ?>" maxlength="<?php echo $_SESSION["tribCar"]; ?>" class="form-control-modern" autocomplete="off" required/>
                        </div>
                    </div>
                    <div class="col-md-12">
                         <div class="form-group-modern">
                            <label>Razón Social</label>
                            <input type="text" name="razon_social" id="razon_social" class="form-control-modern input-mayus" autocomplete="off" required/>
                        </div>
                    </div>
                    <div class="col-md-12">
                         <div class="form-group-modern">
                            <label>Dirección</label>
                             <input type="text" name="direccion" id="direccion" class="form-control-modern" autocomplete="off" required/>
                        </div>
                    </div>
                    <div class="col-md-6">
                         <div class="form-group-modern">
                            <label>Teléfono</label>
                            <input type="text" name="telefono" id="telefono" class="form-control-modern" autocomplete="off"/>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group-modern">
                            <label>Correo electrónico</label>
                            <input type="text" name="email" id="email" class="form-control-modern" autocomplete="off"/>
                        </div>
                    </div>
                    <div class="col-md-12">
                         <div class="form-group-modern">
                            <label>Contacto</label>
                            <input type="text" name="contacto" id="contacto" class="form-control-modern" autocomplete="off"/>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer modal-footer-modern">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success text-white shadow-sm">Guardar Proveedor</button>
            </div>
            </form>
        </div>
    </div>
</div>

<script id="table-detalle-template" type="text/x-jsrender" src="">
    {{for items}}
    <tr class="active">
        <td style="width: 10%;">
            <input name="cantidad_insumo" class="form-control-modern text-center p-1" type="text" value="{{:cantidad_insumo}}" autocomplete="off" onchange="compra.actualizar({{:id}}, this);"/>
        </td>
        <td style="width: 40%;">
            <input name="id_tipo_ins_insumo" type="hidden" value="{{:id_tipo_ins_insumo}}" />
            <input name="id_ins_insumo" type="hidden" value="{{:id_ins_insumo}}" />
            <h6 name="nombre_insumo" class="mb-0 font-weight-bold">{{:nombre_insumo}}</h6>
        </td>
        <td style="width: 10%;">
            <span class="badge badge-warning text-uppercase" name="unidad_medida_insumo">{{:unidad_medida_insumo}}</span>
        </td>
        <td style="width: 15%;" class="dec">
            <input name="precio_insumo" class="form-control-modern text-center p-1" type="text" value="{{:precio_insumo}}" onchange="compra.actualizar({{:id}}, this);" autocomplete="off"/>
        </td>
        <td style="width: 15%;">
            <input type="text" name="importe" class="form-control-modern bg-light text-center p-1" value="{{:total}}" disabled="true"/>
        </td>
        <td class="text-right" style="width: 10%;">
            <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger border-0" onclick="compra.retirar({{:id}});"><i data-feather="trash-2" class="feather-sm"></i></a>
        </td>
    </tr>
    {{/for}}
</script>