<?php
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$fecha = date("d-m-Y");
$fechaa = date("m-Y");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>

<style>
/* === VARIABLES CSS (Extract from monitor.php) === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 2px 10px rgba(0,0,0,0.08);
    --card-shadow-hover: 0 5px 20px rgba(0,0,0,0.12);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    position: relative;
    overflow: hidden;
}

.page-titles-modern::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -10%;
    width: 200px;
    height: 200px;
    background: rgba(255,255,255,0.1);
    border-radius: 50%;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === STATS CARDS === */
.stats-container {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    display: flex;
    align-items: center;
    border-bottom: 4px solid transparent;
    transition: var(--transition);
}

.stat-card:hover { transform: translateY(-3px); }

.stat-icon-wrapper {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    margin-right: 1rem;
    flex-shrink: 0;
}

.stat-content {
    flex-grow: 1;
}

.stat-card h2 {
    font-size: 1.5rem; /* Reduced from 2rem */
    font-weight: 600; /* Reduced weight */
    margin-bottom: 0.2rem;
    color: #333;
}

.stat-card h6 {
    color: #888;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    margin: 0;
    font-weight: 500;
}

/* Variant Styles */
.stat-danger { border-bottom-color: var(--danger-color); }
.stat-danger .stat-icon-wrapper { background: rgba(231, 76, 60, 0.1); color: var(--danger-color); }
.stat-danger h2 { color: var(--danger-color); }

.stat-warning { border-bottom-color: var(--warning-color); }
.stat-warning .stat-icon-wrapper { background: rgba(244, 161, 0, 0.1); color: var(--warning-color); }
.stat-warning h2 { color: var(--warning-color); }

.stat-success { border-bottom-color: var(--success-color); }
.stat-success .stat-icon-wrapper { background: rgba(27, 201, 67, 0.1); color: var(--success-color); }
.stat-success h2 { color: var(--success-color); }

.stat-info { border-bottom-color: var(--info-color); }
.stat-info .stat-icon-wrapper { background: rgba(52, 152, 219, 0.1); color: var(--info-color); }
.stat-info h2 { color: var(--info-color); }

/* === FILTERS CARD === */
.filters-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    box-shadow: var(--card-shadow);
    margin-bottom: 2rem;
}

.form-group-modern label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
    margin-bottom: 0.4rem;
    display: block;   
}

.input-group-modern {
    display: flex;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    overflow: hidden;
}

.input-group-modern .form-control {
    border: none;
    text-align: center;
}

.input-group-modern span {
    background: #f1f3f5;
    padding: 0.6rem 1rem;
    color: #666;
    font-size: 0.9rem;
    border-left: 1px solid #e0e0e0;
    border-right: 1px solid #e0e0e0;
    display: flex;
    align-items: center;
}

/* === TABLE MODERN === */
.table-card {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    overflow: hidden;
}

.table-modern {
    width: 100%;
    margin-bottom: 0;
}

.table-modern thead th {
    background: #f8f9fa;
    color: #495057;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    padding: 1rem;
    border-bottom: 2px solid #e9ecef;
}

.table-modern tbody td {
    padding: 1rem;
    vertical-align: middle;
    border-bottom: 1px solid #f1f3f5;
    font-size: 0.9rem;
}

/* === MODAL MODERN === */
.modal-content-modern {
    border: none;
    border-radius: 15px;
    box-shadow: 0 15px 50px rgba(0,0,0,0.2);
}

.modal-header-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem;
    border-radius: 15px 15px 0 0;
    color: white;
}

.modal-body-modern {
    padding: 2rem;
}

.detail-row {
    margin-bottom: 1rem;
    border-bottom: 1px solid #f0f0f0;
    padding-bottom: 0.5rem;
    display: flex;
    justify-content: space-between;
}

.detail-label { font-weight: 600; color: #666; }
.detail-value { font-weight: 500; color: #333; }

.animate-in { animation: fadeInUp 0.6s ease; }
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fas fa-hand-holding-usd mr-2"></i>Créditos / Cuentas por Pagar</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Inicio</span>
            <span class="breadcrumb-item">/</span>
            <span class="breadcrumb-item active">Gestión de Créditos</span>
        </div>
    </div>
</div>

<!-- STATS -->
<div class="stats-container animate-in">
    <div class="stat-card stat-danger">
        <div class="stat-icon-wrapper"><i class="fas fa-money-bill-wave"></i></div>
        <div class="stat-content">
            <h2 class="total-deuda">0.00</h2>
            <h6>Total Deuda</h6>
        </div>
    </div>
    <div class="stat-card stat-warning">
        <div class="stat-icon-wrapper"><i class="fas fa-percentage"></i></div>
        <div class="stat-content">
            <h2 class="total-interes">0.00</h2>
            <h6>Interés Generado</h6>
        </div>
    </div>
    <div class="stat-card stat-success">
         <div class="stat-icon-wrapper"><i class="fas fa-check-circle"></i></div>
        <div class="stat-content">
            <h2 class="total-amortizado">0.00</h2>
            <h6>Total Amortizado</h6>
        </div>
    </div>
    <div class="stat-card stat-info">
        <div class="stat-icon-wrapper"><i class="fas fa-clock"></i></div>
        <div class="stat-content">
            <h2 class="total-pendiente">0.00</h2>
            <h6>Saldo Pendiente</h6>
        </div>
    </div>
</div>

<!-- FILTERS -->
<div class="filters-card animate-in">
    <div class="row">
        <div class="col-md-4 mb-3 mb-md-0">
            <div class="form-group-modern">
                <label><i class="far fa-calendar-alt mr-1"></i>Rango de Fechas</label>
                <div class="input-group-modern">
                    <input type="text" class="form-control" name="start" id="start" value="<?php echo '01-'.$fechaa; ?>" autocomplete="off" placeholder="Inicio"/>
                    <span>al</span>
                    <input type="text" class="form-control" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off" placeholder="Fin"/>
                </div>
            </div>
        </div>
        <div class="col-md-8">
            <div class="form-group-modern">
                <label><i class="fas fa-truck mr-1"></i>Filtrar por Proveedor</label>
                <select class="selectpicker form-control" name="filtro_proveedor" id="filtro_proveedor" data-style="btn-white border" data-live-search="true" data-size="5" autocomplete="off">
                    <option value="%" active>Mostrar Todos</option>
                    <optgroup label="Proveedores">
                        <?php foreach($this->Proveedores as $key => $value): ?>
                            <option value="<?php echo $value['id_prov']; ?>"><?php echo $value['ruc'].' - '.$value['razon_social']; ?></option>
                        <?php endforeach; ?>
                    </optgroup>
                </select>
            </div>
        </div>
    </div>
</div>

<!-- TABLE -->
<div class="table-card animate-in">
    <div class="table-responsive">
        <table id="table" class="table table-modern" width="100%">
            <thead>
                <tr>
                    <th class="text-left">Fecha pago</th>
                    <th width="20%">Proveedor</th>
                    <th>Documento</th>
                    <th>Deuda</th>
                    <th>Inter&eacute;s</th>
                    <th>Amortizado</th>
                    <th>Pendiente</th>
                    <th class="text-center">Acciones</th>
                </tr>
            </thead>
            <tbody class="tb-st"></tbody>
        </table>
    </div>
</div>

<!-- MODAL AMORTIZAR -->
<div class="modal inmodal" id="modal-credito" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <form id="form-credito" method="post">
                <input type="hidden" name="id_credito" id="id_credito">
                <input type="hidden" name="total_credito" id="total_credito">
                <input type="hidden" name="monto_amortizado" id="monto_amortizado">
                
                <div class="modal-header modal-header-modern p-3">
                    <h5 class="modal-title font-weight-bold title-detalle" style="font-size: 1.1rem;">Amortizar Crédito</h5>
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span></button>
                </div>
                
                <div class="modal-body modal-body-modern p-4">
                    <div class="detail-row">
                        <span class="detail-label">Fecha:</span>
                        <span class="detail-value c-fecha-comp"></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Proveedor:</span>
                        <span class="detail-value c-datos-prov" style="text-align: right; max-width: 60%; display: inline-block;"></span>
                    </div>
                    <div class="detail-row border-0">
                        <span class="detail-label text-danger">Pendiente:</span>
                        <span class="detail-value text-danger font-weight-bold c-monto-pend"></span>
                    </div>
                    
                    <div class="form-group-modern mt-3">
                        <label>Monto a Pagar (<?php echo Session::get('moneda'); ?>)</label>
                        <input type="text" class="form-control form-control-lg border" name="importe" id="importe" autocomplete="off" required style="font-weight: bold; text-align: center; color: var(--success-color);">
                    </div>

                    <div class="mt-3">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input egreso" id="egreso" name="egreso">
                            <label class="custom-control-label" for="egreso">Registrar como egreso de caja</label>
                        </div>
                        
                        <div class="monto-egreso mt-2" style="display: none;">
                             <label class="small text-muted">Monto Egreso</label>
                            <input type="text" class="form-control form-control-sm border" name="monto_egreso" id="monto_egreso" autocomplete="off" placeholder="Monto">
                        </div>
                    </div>
                </div>

                <div class="modal-footer p-3 border-top-0 justify-content-center">
                    <button type="button" class="btn btn-light" data-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success shadow-sm px-4">Confirmar Pago</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- MODAL DETALLE -->
<div class="modal inmodal" id="modal-detalle" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content modal-content-modern">
            <div class="modal-header modal-header-modern">
                <h5 class="modal-title m-0"><i class="fas fa-history mr-2"></i>Historial de Pagos</h5>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body modal-body-modern p-0">
                <table class="table table-modern table-sm mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th class="pl-4">Cajero</th>
                            <th>Fecha/Hora</th>
                            <th>Egreso Caja</th>
                            <th class="text-right pr-4">Importe</th>
                        </tr>
                    </thead>
                    <tbody class="tb-st" id="table-detalle"></tbody>
                </table>
            </div>
            <div class="modal-footer p-3">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>