<?php
    date_default_timezone_set($_SESSION["zona_horaria"]);
    setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
    $fecha = date("d-m-Y h:i A");
    $fechaa = date("m-Y 07:00");
?>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 4px 20px rgba(0,0,0,0.05);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MODERN === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
    transition: color 0.2s;
}

.breadcrumb-modern a:hover {
    color: white;
    text-decoration: underline;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === CARDS & STATS === */
.card-modern {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    border: none;
    margin-bottom: 1.5rem;
    transition: var(--transition);
}

.filter-header {
    background: #f8f9fa;
    padding: 1rem 1.5rem;
    border-bottom: 1px solid #eee;
    font-weight: 600;
    color: var(--dark-color);
    border-radius: var(--border-radius) var(--border-radius) 0 0;
}

/* === TABLES === */
.table-modern thead {
    background: linear-gradient(135deg, #667eea 0%, var(--primary-color) 100%);
    color: white;
}
.table-modern thead th {
    padding: 1rem !important;
    font-size: 0.85rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-weight: 600;
    border: none;
}
.table-modern tbody td {
    padding: 1rem !important;
    font-size: 0.9rem;
    vertical-align: middle;
    border-bottom: 1px solid #f0f0f0;
}
.table-modern tbody tr:hover {
    background-color: #f8f9fa;
}

/* === TABS === */
.nav-tabs.customtab .nav-link.active {
    border-bottom: 2px solid var(--primary-color);
    color: var(--primary-color);
    font-weight: 500;
}
.nav-tabs.customtab .nav-link {
    border: none;
    color: #666;
    padding: 0.8rem 1rem;
}
.animate-in { animation: fadeInUp 0.5s ease; }
@keyframes fadeInUp { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
</style>

<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fas fa-money-check-alt mr-2"></i>Informe de Finanzas: Personal</h4>
        <div class="breadcrumb-modern">
            <a href="<?php echo URL; ?>informe" class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Inicio</a>
            <a href="<?php echo URL; ?>informe" class="breadcrumb-item">Finanzas</a>
            <span class="breadcrumb-item active">Personal</span>
        </div>
    </div>
</div>

<div class="row">
    <!-- Filter Column -->
    <div class="col-lg-4">
        <div class="card card-modern animate-in" style="animation-delay: 0.1s;">   
            <div class="filter-header"><i class="fas fa-filter mr-2"></i>Filtros de Búsqueda</div>
            <div class="card-body">
                <div class="form-group mb-3">
                    <label>Personal</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-light"><i class="fas fa-user"></i></span>
                        </div>
                        <select class="selectpicker form-control" name="filtro_personal" id="filtro_personal" data-style="btn-light" data-live-search="true" title="Seleccionar">
                            <?php foreach($this->Personal as $key => $value): ?>
                                <option value="<?php echo $value['id_usu']; ?>"><?php echo $value['nombres'].' '.$value['ape_paterno'].' '.$value['ape_materno']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div> 
                <div class="form-group mb-3">
                    <label>Inicio</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-light"><i class="far fa-calendar-alt"></i></span>
                        </div>
                        <input type="text" class="form-control" name="start" id="start" value="<?php echo '01-'.$fechaa.' AM'; ?>" autocomplete="off"/>
                    </div>
                </div>
                <div class="form-group mb-4">
                    <label>Final</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text bg-light"><i class="far fa-calendar-alt"></i></span>
                        </div>
                        <input type="text" class="form-control" name="end" id="end" value="<?php echo $fecha; ?>" autocomplete="off">
                    </div>
                </div>
            </div>
            
            <div class="card-body p-0">
                <div class="bg-primary text-white text-center p-4" style="border-radius: 0 0 12px 12px;">
                    <h1 class="font-weight-bold mb-0"><?php echo Session::get('moneda'); ?><span class="monto-global">0.00</span></h1>
                    <p class="mb-0 text-white-50">Monto Global</p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Data Column -->
    <div class="col-lg-8">
        <div class="card card-modern animate-in" style="animation-delay: 0.2s;">
            <div class="card-body p-0">
                <ul class="nav nav-tabs customtab pl-3 pt-3" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-toggle="tab" href="#tab1" role="tab" aria-selected="true"><span class="hidden-sm-up">Egresos</span> <span class="hidden-xs-down">Egresos</span></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-toggle="tab" href="#tab2" role="tab" aria-selected="false"><span class="hidden-sm-up">Ventas al crédito</span> <span class="hidden-xs-down">Ventas al crédito</span></a>
                    </li>
                </ul>
                
                <div class="tab-content p-3">
                    <!-- TAB 1: Egresos -->
                    <div class="tab-pane active" id="tab1" role="tabpanel">
                        <div class="row text-center mb-4 mt-2">
                            <div class="col-6 border-right">
                                <h3 class="font-weight-bold text-dark m-b-0 ventas-operaciones-1">0</h3>
                                <small class="text-muted">N° Operaciones</small>
                            </div>
                            <div class="col-6">
                                <h3 class="font-weight-bold text-success m-b-0"><?php echo Session::get('moneda'); ?><span class="ventas-total-1">0.00</span></h3>
                                <small class="text-muted">Total</small>
                            </div>
                        </div>
                        
                        <div class="table-responsive">
                            <table id="table-1" class="table table-modern table-hover" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th style="width: 15%;">Fecha</th>
                                        <th style="width: 25%;">Responsable</th>
                                        <th style="width: 50%;">Motivo</th>
                                        <th style="width: 10%; text-align: right;">Monto</th>
                                    </tr>
                                </thead>
                                <tbody class="tb-st"></tbody>
                            </table>
                        </div>
                    </div>
                    
                    <!-- TAB 2: Ventas al Credito -->
                    <div class="tab-pane" id="tab2" role="tabpanel">
                        <div class="row text-center mb-4 mt-2">
                            <div class="col-6 border-right">
                                <h3 class="font-weight-bold text-dark m-b-0 ventas-operaciones-2">0</h3>
                                <small class="text-muted">N° Operaciones</small>
                            </div>
                            <div class="col-6">
                                <h3 class="font-weight-bold text-success m-b-0"><?php echo Session::get('moneda'); ?><span class="ventas-total-2">0.00</span></h3>
                                <small class="text-muted">Total</small>
                            </div>
                        </div>
                        
                        <div class="table-responsive">
                            <table id="table-2" class="table table-modern table-hover" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th style="width: 15%;">Fecha</th>
                                        <th style="width: 25%;">Responsable</th>
                                        <th style="width: 40%;">Documento</th>
                                        <th style="width: 10%; text-align: right;">Monto</th>
                                        <th style="width: 10%;">Opciones</th>
                                    </tr>
                                </thead>
                                <tbody class="tb-st"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Row -->