<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<style>
/* === VARIABLES CSS === */
:root {
    --primary-color: #5664d2;
    --success-color: #1bc943;
    --warning-color: #f4a100;
    --danger-color: #e74c3c;
    --info-color: #3498db;
    --dark-color: #2c3e50;
    --light-bg: #f8f9fa;
    --card-shadow: 0 4px 20px rgba(0,0,0,0.05);
    --border-radius: 12px;
    --transition: all 0.3s ease;
}

/* === HEADER MEJORADO === */
.page-titles-modern {
    background: linear-gradient(135deg, var(--primary-color) 0%, #667eea 100%);
    padding: 1.5rem 2rem;
    border-radius: var(--border-radius);
    margin-bottom: 2rem;
    color: white;
    box-shadow: var(--card-shadow);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.page-titles-modern h4 {
    color: white;
    font-weight: 600;
    margin-bottom: 0.5rem;
    font-size: 1.5rem;
}

.breadcrumb-modern {
    background: rgba(255, 255, 255, 0.2);
    padding: 0.4rem 1rem;
    border-radius: 20px;
    display: inline-block;
    font-size: 0.9rem;
}

.breadcrumb-modern .breadcrumb-item, .breadcrumb-modern a {
    color: rgba(255, 255, 255, 0.9);
    text-decoration: none;
}

.breadcrumb-modern .breadcrumb-item.active {
    color: white;
    font-weight: 500;
}

/* === CARDS MODERNAS === */
.card-modern {
    background: white;
    border-radius: var(--border-radius);
    box-shadow: var(--card-shadow);
    border: none;
    margin-bottom: 2rem;
    overflow: hidden;
}

.card-header-modern {
    padding: 1.2rem 1.5rem;
    border-bottom: 1px solid #f0f0f0;
    background: white;
}

.card-title-modern {
    font-size: 1.1rem;
    font-weight: 700;
    color: #333;
    margin: 0;
}

.card-body-modern {
    padding: 1.5rem;
}

/* === FORMULARIOS === */
.form-group-modern {
    margin-bottom: 1.2rem;
}

.form-group-modern label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #555;
    margin-bottom: 0.5rem;
    display: block;
}

.form-control-modern {
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 0.6rem 1rem;
    font-size: 0.95rem;
    width: 100%;
}

.form-control-modern:focus {
    border-color: var(--primary-color);
    outline: none;
}

/* === INPUT CONSISTENCY === */
.form-control-modern, 
.bootstrap-select .dropdown-toggle,
.equivalence-box {
    height: 45px !important; /* Fixed height for consistency */
    padding: 0.5rem 1rem !important;
    font-size: 0.95rem;
    border-radius: 8px !important;
    border: 1px solid #e0e0e0 !important;
    display: flex;
    align-items: center;
    background-color: #fff;
}

.bootstrap-select .dropdown-toggle {
    background: #fff !important; /* Override btn-light */
}

.bootstrap-select .dropdown-toggle:focus {
    outline: none !important;
    border-color: var(--primary-color) !important;
    background: #fff !important;
}

.equivalence-box {
    background-color: #f8f9fa !important;
    color: #6c757d;
}

/* === TABLE === */
.table-modern {
    width: 100%;
    margin-bottom: 0;
    border-collapse: separate;
    border-spacing: 0;
}

.table-modern thead th {
    background: #fff;
    color: #8898aa;
    font-weight: 600;
    font-size: 0.75rem;
    padding: 1rem 1.5rem;
    text-transform: uppercase;
    letter-spacing: 1px;
    border-bottom: 1px solid #e9ecef;
}

.table-modern tbody td {
    padding: 1rem 1.5rem;
    vertical-align: middle;
    border-bottom: 1px solid #f6f9fc;
    color: #525f7f;
    font-size: 0.875rem;
}

.table-modern tbody tr:hover td {
    background-color: #f6f9fc;
}

.table-modern tbody tr:last-child td {
    border-bottom: none;
}

/* === CUSTOM ALERTS === */
.selection-box {
    background: #f8f9fa;
    border-radius: 12px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    border: 1px solid #e9ecef;
}

.animate-in { animation: fadeInUp 0.6s ease; }
@keyframes fadeInUp {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>

<!-- HEADER -->
<div class="page-titles-modern animate-in">
    <div>
        <h4><i class="fas fa-edit mr-2"></i>Nuevo Ajuste de Stock</h4>
        <div class="breadcrumb-modern">
            <span class="breadcrumb-item"><i class="fas fa-home mr-1"></i>Inventario</span>
            <span class="breadcrumb-item">/</span>
            <span class="breadcrumb-item"><a href="<?php echo URL; ?>inventario/ajuste">Ajustes</a></span>
            <span class="breadcrumb-item">/</span>
            <span class="breadcrumb-item active">Nuevo</span>
        </div>
    </div>
</div>

<form id="form" method="post">
<div class="row">
    <!-- LEFT COLUMN: GENERAL INFO -->
    <div class="col-lg-3 col-md-12 mb-3">
        <div class="card card-modern animate-in">
            <div class="card-header-modern">
                <h5 class="card-title-modern"><i class="fas fa-info-circle mr-2 text-primary"></i>Datos Generales</h5>
            </div>
            <div class="card-body-modern">
                <div class="form-group-modern">
                    <label>Tipo Operación</label>
                    <select class="selectpicker form-control" name="id_tipo" id="id_tipo" data-style="btn-light border" title="Seleccionar..." required>
                        <option value="3">ENTRADA</option>
                        <option value="4">SALIDA</option>
                    </select>
                </div>

                <div class="form-group-modern">
                    <label>Responsable</label>
                    <select class="selectpicker form-control" name="id_responsable" id="id_responsable" data-style="btn-light border" data-live-search="true" title="Seleccionar..." required>
                        <?php foreach($this->Responsable as $key => $value): ?>
                            <option value="<?php echo $value['id_usu']; ?>"><?php echo $value['nombres'].' '.$value['ape_paterno'].' '.$value['ape_materno']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group-modern">
                    <label>Descripción / Motivo</label>
                    <textarea name="motivo" id="motivo" class="form-control form-control-modern" rows="4" style="resize: none;" required placeholder="Ingrese el motivo del ajuste..."></textarea>
                </div>
            </div>
        </div>
    </div>

    <!-- RIGHT COLUMN: DETAILS -->
    <div class="col-lg-9 col-md-12">
        <div class="card card-modern animate-in">
            <div class="card-header-modern">
                <h5 class="card-title-modern">Detalle de Ajuste</h5>
                <h6 class="text-muted mb-0 font-weight-normal">Agregue los items a ajustar</h6>
            </div>
            
            <div class="card-body-modern">
                 <!-- SEARCH BAR -->
                 <div class="form-group-modern">
                    <label><i class="fas fa-search mr-1"></i>Buscar Producto o Insumo</label>
                    <input type="text" name="buscar_insumo" id="buscar_insumo" class="form-control-modern" placeholder="Escriba para buscar por nombre o código..." autocomplete="off"/>
                    <input type="hidden" name="id_tipo_ins_buscar" id="id_tipo_ins_buscar"/>
                    <input type="hidden" name="id_ins_buscar" id="id_ins_buscar"/>
                 </div>

                <!-- INFO SELECTION (Hidden by default, shown when selected) -->
                <!-- Important: The class 'nvo-ins' is used by JS to toggle visibility -->
                <div class="nvo-ins" style="display: none;">
                    
                    <div class="selection-box">
                         <!-- ITEM INFO BANNER -->
                        <div class="d-flex align-items-center flex-wrap mb-3 pb-3 border-bottom">
                            <h6 class="mb-0 mr-2 text-muted">Item Seleccionado:</h6>
                            <h5 class="mb-0 text-dark font-weight-bold mr-3" id="label-insumo"></h5>
                            <span class="badge badge-info p-2" id="label-medida"></span>
                        </div>

                         <!-- INPUTS ROW -->
                         <div class="row align-items-end">
                             <div class="col-md-3">
                                 <div class="form-group-modern mb-md-0">
                                     <label>Cantidad</label>
                                     <input type="text" name="cantidad_buscar" id="cantidad_buscar" class="form-control-modern text-center font-weight-bold" autocomplete="off" placeholder="0"/>
                                 </div>
                             </div>
                             <div class="col-md-3">
                                  <div class="form-group-modern mb-md-0">
                                     <label>Unidad Medida</label>
                                     <select name="medida_buscar" id="medida_buscar" class="selectpicker form-control" data-style="btn-light border" data-size="5" title="-"></select>
                                 </div>
                             </div>
                             <div class="col-md-4">
                                  <label class="d-block">Equivalencia</label>
                                  <div class="equivalence-box">
                                      <span id="cantidad_equivalente_buscar" class="font-weight-bold text-dark mr-1">0</span> 
                                      <span id="label-unidad-medida"></span>
                                  </div>
                             </div>
                              <div class="col-md-2">
                                  <div class="form-group-modern mb-md-0">
                                      <label>P.U. Costo</label>
                                      <input class="form-control-modern text-center" type="text" name="precio_buscar" id="precio_buscar" autocomplete="off" placeholder="0.00">
                                  </div>
                             </div>
                         </div>
                         
                         <div class="text-right mt-3">
                            <button type="button" class="btn btn-danger btn-eliminar-insumo mr-2"><i class="fas fa-trash"></i> Cancelar</button>
                            <button type="button" class="btn btn-success btn-agregar-insumo"><i class="fas fa-plus"></i> Agregar</button>
                         </div>
                    </div>
                </div>

                <!-- TABLE -->
                <div class="table-responsive mt-4">
                    <table class="table table-modern">
                        <thead>
                            <tr>
                                <th width="10%">Tipo</th>
                                <th width="40%">Nombre</th>
                                <th width="15%" class="text-center">Cantidad</th>
                                <th width="15%">U. Medida</th>
                                <th width="10%" class="text-center">P.U.</th>
                                <th width="10%" class="text-right">Acción</th>
                            </tr>
                        </thead>
                        <tbody id="table-detalle" class="tb-st"></tbody>
                    </table>
                </div>
            </div>
            
            <div class="card-footer bg-white border-top-0 text-right p-3">
                <a class="btn btn-light border mr-2" href="<?php echo URL; ?>inventario/ajuste">Cancelar</a>
                <button class="btn btn-success shadow-sm px-4">Guardar Ajuste</button>
            </div>
        </div>
    </div>
</div>
</form>

<script id="table-detalle-template" type="text/x-jsrender" src="">
    {{for items}} 
        <tr class="active">
            <td>
                <span class="badge {{if tipo == 'PRODUCTO'}}badge-primary{{else}}badge-secondary{{/if}}">{{:tipo}}</span>
            </td>
            <td>
                <input name="id_ins_insumo" type="hidden" value="{{:id_ins_insumo}}" />
                <input name="id_tipo_ins_insumo" type="hidden" value="{{:id_tipo_ins_insumo}}" />
                <span class="font-weight-bold">{{:nombre_insumo}}</span>
            </td>
            <td class="text-center">
                {{:cantidad_insumo}}
            </td>
            <td>
                <span class="badge badge-warning text-uppercase" name="unidad_medida_insumo">{{:unidad_medida_insumo}}</span>
            </td>
            <td class="text-center">
                <?php echo Session::get('moneda'); ?> {{:precio_insumo}}
            </td>
            <td class="text-right">
                <a href="javascript:void(0)" class="btn btn-sm btn-outline-danger border-0" onclick="facturador.retirar({{:id}});"><i data-feather="trash-2" class="feather-sm"></i></a>
            </td>
        </tr>
    {{/for}}
</script>