document.addEventListener("DOMContentLoaded", () => {
    let productosEnCarrito = JSON.parse(localStorage.getItem("productos-en-carrito")) || [];
    const Img_URL = 'https://pale.tufacturaya.com/restaurantepro/facturacion/public/images/productos/';
   
    const contCarritoVacio = document.querySelector("#carrito-vacio");
    const contCarritoProductos = document.querySelector("#carrito-productos");
    const contCarritoAcciones = document.querySelector("#carrito-acciones");
    const contCarritoComprado = document.querySelector("#carrito-comprado");
    const botonVaciar = document.querySelector("#carrito-acciones-vaciar");
    const contTotal = document.querySelector("#total");
    const botonComprar = document.querySelector("#carrito-acciones-comprar");

    function cargarProductosCarrito() {
        if (productosEnCarrito && productosEnCarrito.length > 0) {
            contCarritoVacio.classList.add("disabled");
            contCarritoProductos.classList.remove("disabled");
            contCarritoAcciones.classList.remove("disabled");
            contCarritoComprado.classList.add("disabled");
    
            contCarritoProductos.innerHTML = "";
    
            productosEnCarrito.forEach(producto => {
                const div = document.createElement("div");
                div.classList.add("carrito-producto");
                div.innerHTML = `
                    <img class="carrito-producto-imagen" src="${Img_URL + producto.archivo_imagen}" alt="${producto.presentacion}">
                    <div class="carrito-producto-titulo">
                        <small>Producto</small>
                        <h5 class="mb-0">${producto.presentacion}</h5>
                    </div>
                    <div class="carrito-producto-cantidad">
                        <small>Cantidad</small>
                        <p class="mb-0">${producto.cantidad}</p>
                    </div>
                    <div class="carrito-producto-precio">
                        <small>Precio</small>
                        <p class="mb-0">S/ ${parseFloat(producto.precio).toFixed(2)}</p>
                    </div>
                    <div class="carrito-producto-subtotal">
                        <small>Subtotal</small>
                        <p class="mb-0 fw-bold">S/ ${(producto.precio * producto.cantidad).toFixed(2)}</p>
                    </div>
                    <button class="carrito-producto-eliminar btn btn-sm btn-outline-danger" id="${producto.id}"><i class="bi bi-trash-fill"></i></button>
                `;
                contCarritoProductos.append(div);
            });
        } else {
            contCarritoVacio.classList.remove("disabled");
            contCarritoProductos.classList.add("disabled");
            contCarritoAcciones.classList.add("disabled");
            contCarritoComprado.classList.add("disabled");
        }
        actualizarBotonesEliminar();
        actualizarTotal();
    }

    function actualizarBotonesEliminar() {
        const botonesEliminar = document.querySelectorAll(".carrito-producto-eliminar");
        botonesEliminar.forEach(boton => {
            boton.addEventListener("click", eliminarDelCarrito);
        });
    }

    function eliminarDelCarrito(e) {
        Toastify({ text: "Producto eliminado", duration: 2000, style: { background: "red" } }).showToast();
        const idBoton = e.currentTarget.id;
        const index = productosEnCarrito.findIndex(producto => producto.id == idBoton); // Usar == por si los tipos difieren
        if (index > -1) {
            productosEnCarrito.splice(index, 1);
            guardarYRecargar();
        }
    }

    function vaciarCarrito() {
        Swal.fire({
            title: '¿Estás seguro?',
            text: `Se van a borrar ${productosEnCarrito.reduce((acc, p) => acc + p.cantidad, 0)} productos.`,
            icon: 'warning', showCancelButton: true, confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33', confirmButtonText: 'Sí, vaciar', cancelButtonText: 'No'
        }).then((result) => {
            if (result.isConfirmed) {
                productosEnCarrito = [];
                guardarYRecargar();
                Swal.fire('¡Vaciado!', 'Tu carrito ha sido vaciado.', 'success');
            }
        });
    }

    function actualizarTotal() {
        const totalCalculado = productosEnCarrito.reduce((acc, p) => acc + (p.precio * p.cantidad), 0);
        contTotal.innerText = `S/ ${totalCalculado.toFixed(2)}`;
    }

    function comprarCarrito() {
        productosEnCarrito = [];
        guardarYRecargar();
        contCarritoComprado.classList.remove("disabled");
        contCarritoVacio.classList.add("disabled");
        contCarritoProductos.classList.add("disabled");
        contCarritoAcciones.classList.add("disabled");
    }

    function guardarYRecargar() {
        localStorage.setItem("productos-en-carrito", JSON.stringify(productosEnCarrito));
        cargarProductosCarrito();
    }

    botonVaciar.addEventListener("click", vaciarCarrito);
    botonComprar.addEventListener("click", comprarCarrito);

    cargarProductosCarrito();
});